/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.layout;

import jp.sf.maskat.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class NewLayoutFileWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text layoutNameText;
    private ISelection selection;

    public NewLayoutFileWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.getString("wizard.layout.title"));
        this.setDescription(Messages.getString("wizard.layout.description"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.getString("wizard.layout.label.container"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLayoutFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.getString("wizard.layout.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("wizard.layout.label.finename"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLayoutFileWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("wizard.layout.label.layout"));
        this.layoutNameText = new Text(container, 2052);
        this.layoutNameText.setText("newLayout");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.layoutNameText.setLayoutData((Object)gd);
        this.layoutNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLayoutFileWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText("newLayout.xml");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("wizard.layout.browse.title"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.getString("wizard.layout.msg.error.container.invalidname"));
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            Object[] msgArgs = new String[]{this.getContainerName()};
            this.updateStatus(Messages.format("wizard.layout.msg.error.container.mustexist", msgArgs));
            return;
        }
        if (!container.isAccessible()) {
            Object[] msgArgs = new String[]{this.getContainerName()};
            this.updateStatus(Messages.format("wizard.layout.msg.error.container.mustwritable", msgArgs));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.getString("wizard.layout.msg.error.filename.invalidname"));
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.getString("wizard.layout.msg.error.filename.invalidchar"));
            return;
        }
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus nameStatus = workspace.validateName(fileName, 1);
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus.getMessage());
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1) {
            String ext = fileName.substring(dotLoc + 1);
            if (!ext.equalsIgnoreCase("xml")) {
                this.updateStatus(Messages.getString("wizard.layout.msg.error.filename.invalidextension"));
                return;
            }
        } else {
            this.updateStatus(Messages.getString("wizard.layout.msg.error.filename.invalidextension"));
            return;
        }
        String layoutName = this.getLayoutName();
        if (layoutName.length() == 0) {
            this.updateStatus(Messages.getString("wizard.layout.msg.error.invalidlayoutname"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getLayoutName() {
        return this.layoutNameText.getText();
    }
}

