/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.export;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class XMLSchemaSelectGroup
extends EventManager {
    private Object root;
    private Object currentTreeSelection;
    private Object currentListSelection;
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private TreeViewer treeViewer;
    private TableViewer listViewer;
    private Control okControl = null;

    public XMLSchemaSelectGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.createContents(parent, width, height, style);
    }

    public void setSelectionControl(Control c) {
        this.okControl = c;
        if (this.okControl != null) {
            this.okControl.setEnabled(false);
        }
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createTreeViewer(composite, width / 2, height);
        this.createListViewer(composite, width / 2, height);
        this.initialize();
    }

    protected void createListViewer(Composite parent, int width, int height) {
        this.listViewer = new TableViewer(parent, 2048);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addSelectionChangedListener((ISelectionChangedListener)new ListViewerListener());
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2048);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewerListener());
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    public Object getSelectObject() {
        return this.currentListSelection;
    }

    private class ListViewerListener
    implements ISelectionChangedListener {
        private ListViewerListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && XMLSchemaSelectGroup.this.okControl != null) {
                XMLSchemaSelectGroup.this.currentListSelection = selectedElement;
                XMLSchemaSelectGroup.this.okControl.setEnabled(true);
            }
        }
    }

    private class TreeViewerListener
    implements ISelectionChangedListener {
        private TreeViewerListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement == null) {
                XMLSchemaSelectGroup.this.currentTreeSelection = null;
                XMLSchemaSelectGroup.this.currentListSelection = null;
                XMLSchemaSelectGroup.this.listViewer.setInput(XMLSchemaSelectGroup.this.currentTreeSelection);
                return;
            }
            if (selectedElement != XMLSchemaSelectGroup.this.currentTreeSelection) {
                XMLSchemaSelectGroup.this.listViewer.setInput(selectedElement);
            }
            XMLSchemaSelectGroup.this.currentTreeSelection = selectedElement;
            XMLSchemaSelectGroup.this.currentListSelection = null;
            if (XMLSchemaSelectGroup.this.okControl != null) {
                XMLSchemaSelectGroup.this.okControl.setEnabled(false);
            }
        }
    }
}

