/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import java.util.ArrayList;
import java.util.List;
import jp.sf.maskat.ui.MaskatUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;

public class CompositePropertyCommand
extends Command {
    private List commands = new ArrayList();
    private boolean order;

    public CompositePropertyCommand() {
        this(true);
    }

    public CompositePropertyCommand(boolean order) {
        this.order = order;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        try {
            int i = 0;
            while (i < this.commands.size()) {
                Command command = (Command)this.commands.get(i);
                if (command.canExecute()) {
                    command.execute();
                }
                ++i;
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public void undo() {
        try {
            if (this.order) {
                int i = this.commands.size() - 1;
                while (i >= 0) {
                    Command command = (Command)this.commands.get(i);
                    if (command.canUndo()) {
                        command.undo();
                    }
                    --i;
                }
            } else {
                int i = 0;
                while (i < this.commands.size()) {
                    Command command = (Command)this.commands.get(i);
                    if (command.canUndo()) {
                        command.undo();
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }
}

