/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaProperty;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.UndoableSetPropertyCommand;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import jp.sf.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import jp.sf.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import jp.sf.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;
import jp.sf.maskat.ui.views.properties.descriptor.NonEditableTextPropertyDescriptor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class DynaBeanPropertySource
implements IPropertySource {
    private static Map classToDescriptorsMap = new HashMap();
    private DynaBean dynaBean;
    private CommandStack commandStack;
    static /* synthetic */ Class class$0;

    public DynaBeanPropertySource(DynaBean dynaBean) {
        this.dynaBean = dynaBean;
    }

    public Object getEditableValue() {
        return this.dynaBean;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        DynaClass dynaClass = this.dynaBean.getDynaClass();
        if (classToDescriptorsMap.containsKey(dynaClass)) {
            return (IPropertyDescriptor[])classToDescriptorsMap.get(dynaClass);
        }
        org.apache.commons.beanutils.DynaProperty[] properties = dynaClass.getDynaProperties();
        int exceptionProps = 0;
        int i = 0;
        while (i < properties.length) {
            if (this.cannotSetInPropertySheet(properties[i])) {
                ++exceptionProps;
            }
            ++i;
        }
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        int i2 = 0;
        while (i2 < properties.length) {
            IPropertyDescriptor descriptor;
            if (!this.cannotSetInPropertySheet(properties[i2]) && (descriptor = this.createPropertyDescriptor(properties[i2])) != null) {
                descriptors.add(descriptor);
            }
            ++i2;
        }
        IPropertyDescriptor[] propertyDescriptors = descriptors.toArray(new IPropertyDescriptor[0]);
        classToDescriptorsMap.put(dynaClass, propertyDescriptors);
        return propertyDescriptors;
    }

    private boolean cannotSetInPropertySheet(org.apache.commons.beanutils.DynaProperty property) {
        return !DynaComponent.isAttributeProperty((String)property.getName());
    }

    private IPropertyDescriptor createPropertyDescriptor(org.apache.commons.beanutils.DynaProperty property) {
        String displayName;
        block13: {
            block12: {
                displayName = property.getName();
                Class propertyType = property.getType();
                String[] itmes = null;
                if (property instanceof DynaProperty) {
                    DynaProperty prop = (DynaProperty)property;
                    if (!prop.isEnabled()) {
                        return null;
                    }
                    itmes = prop.getItems();
                    if ("context".equals(displayName)) {
                        displayName = prop.isCdataSection() ? "#cdata-section" : "#text";
                    }
                    displayName = String.valueOf(displayName) + (prop.isRequired() ? "*" : "");
                    if (!prop.isEditable()) {
                        return new NonEditableTextPropertyDescriptor(property, displayName);
                    }
                }
                if (itmes != null && itmes.length > 0) {
                    return new MaskatComboBoxPropertyDescriptor(property, displayName, itmes);
                }
                if (Boolean.TYPE.equals(propertyType)) break block12;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.equals(propertyType)) break block13;
            }
            return new BooleanComboBoxPropertyDescriptor(property, displayName);
        }
        return new MaskatTextPropertyDescriptor(property, displayName);
    }

    public Object getPropertyValue(Object id) {
        return this.dynaBean.get(this.getPropertyName(id));
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    private String getPropertyName(Object id) {
        return ((org.apache.commons.beanutils.DynaProperty)id).getName();
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value != null && "name".equals(this.getPropertyName(id)) && ComponentUtils.isExistenceId((LayoutElement)((LayoutElement)this.dynaBean).getLayout(), (String)value)) {
            return;
        }
        if (value == null && "name".equals(this.getPropertyName(id))) {
            return;
        }
        if (this.commandStack != null) {
            String oldValue = null;
            try {
                oldValue = BeanUtils.getProperty((Object)this.dynaBean, (String)this.getPropertyName(id));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
                this.commandStack.execute((Command)new UndoableSetPropertyCommand(this.dynaBean, this.getPropertyName(id), value));
            }
            return;
        }
        try {
            if (this.dynaBean.get(this.getPropertyName(id)) == null && value == null) {
                return;
            }
            BeanUtils.setProperty((Object)this.dynaBean, (String)this.getPropertyName(id), (Object)value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }
}

