/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.outline;

import java.util.List;
import jp.sf.maskat.core.layout.AbstractContainer;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditor;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import jp.sf.maskat.ui.editors.layout.outline.OutLineTreeEditPart;
import jp.sf.maskat.ui.editors.layout.outline.OutLineTreeEditPartFactory;
import jp.sf.maskat.ui.editors.layout.tools.IdDirectEditmanger;
import jp.sf.maskat.ui.editors.layout.tools.TextCellEditorLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

public class LayoutOutLinePage
extends ContentOutlinePage
implements ISelectionChangedListener,
IAdaptable {
    public static final String EDITOR_ID = "jp.sf.maskat.ui.outlinePage";
    private LayoutGraphicalEditor editor;
    private EditNameAction directEdit;
    private ISelection selection = null;
    private EditPart beforeSelectionEditPart = null;
    private long beforeSelectionTime = 0L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public LayoutOutLinePage(LayoutGraphicalEditor editor) {
        super((EditPartViewer)new TreeViewer());
        this.editor = editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ActionRegistry registry = (ActionRegistry)this.editor.getAdapter(clazz);
        IActionBars bars = pageSite.getActionBars();
        String delId = ActionFactory.DELETE.getId();
        String undoId = ActionFactory.UNDO.getId();
        String redoId = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(delId, registry.getAction((Object)delId));
        bars.setGlobalActionHandler(undoId, registry.getAction((Object)undoId));
        bars.setGlobalActionHandler(redoId, registry.getAction((Object)redoId));
        bars.updateActionBars();
        this.directEdit = new EditNameAction();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        EditPartViewer viewer = this.getViewer();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GraphicalViewer gviewer = (GraphicalViewer)this.editor.getAdapter(clazz);
        viewer.setEditDomain(gviewer.getEditDomain());
        RootEditPart editPart = gviewer.getRootEditPart();
        viewer.setEditPartFactory((EditPartFactory)new OutLineTreeEditPartFactory(gviewer));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ActionRegistry registry = (ActionRegistry)this.editor.getAdapter(clazz2);
        OutlineContextMenuProvider provider = new OutlineContextMenuProvider(viewer, registry);
        viewer.setContextMenu((MenuManager)provider);
        viewer.setContents(this.getRootModel((EditPart)editPart));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void update() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GraphicalViewer gviewer = (GraphicalViewer)this.editor.getAdapter(clazz);
        this.getViewer().setContents(this.getRootModel((EditPart)gviewer.getRootEditPart()));
    }

    private void updateDeleteActions(ActionRegistry registry) {
        IAction redoAction;
        IAction undoAction;
        IAction delAction = registry.getAction((Object)ActionFactory.DELETE.getId());
        if (delAction instanceof UpdateAction) {
            ((UpdateAction)delAction).update();
        }
        if ((undoAction = registry.getAction((Object)ActionFactory.UNDO.getId())) instanceof UpdateAction) {
            ((UpdateAction)undoAction).update();
        }
        if ((redoAction = registry.getAction((Object)ActionFactory.REDO.getId())) instanceof UpdateAction) {
            ((UpdateAction)redoAction).update();
        }
    }

    private Object getRootModel(EditPart parentElement) {
        List partList = parentElement.getChildren();
        if (partList.size() > 0) {
            Object model = ((EditPart)partList.get(0)).getModel();
            AbstractContainer root = new AbstractContainer(){};
            root.addChild(model);
            return root;
        }
        return null;
    }

    public EditPartViewer getViewer() {
        return super.getViewer();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection sel;
        this.selection = event.getSelection();
        if (this.selection instanceof StructuredSelection && (sel = (StructuredSelection)this.selection) != null && !sel.isEmpty() && sel.getFirstElement() instanceof EditPart) {
            OutLineTreeEditPart editPart = (OutLineTreeEditPart)sel.getFirstElement();
            if (this.beforeSelectionEditPart == editPart && sel.size() == 1 && System.currentTimeMillis() - this.beforeSelectionTime <= 200L) {
                if (this.directEdit.canEdit()) {
                    this.directEdit.run();
                }
            } else {
                GraphicalEditPart g = (GraphicalEditPart)editPart.getLayoutEditPart();
                if (g instanceof ComponentEditPart) {
                    ComponentEditPart part = (ComponentEditPart)g;
                    part.refreshSelectedWidget(null);
                }
            }
            this.beforeSelectionEditPart = editPart;
            this.beforeSelectionTime = System.currentTimeMillis();
        }
    }

    public Object getAdapter(Class adapter) {
        return this.editor.getAdapter(adapter);
    }

    private class EditNameAction
    extends Action {
        public EditNameAction() {
            super.setText(Messages.getString("layout.cmd.rename.msg.title"));
        }

        public boolean canEdit() {
            LayoutElementEditPart editPart = this.getLayoutEditPart();
            if (editPart != null && editPart.getParent() != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IdDirectEditable editable = (IdDirectEditable)editPart.getAdapter(clazz);
                try {
                    if (editable != null && !"".equals(editable.getId())) {
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            return false;
        }

        public boolean canDelete() {
            LayoutElementEditPart editPart = this.getLayoutEditPart();
            return editPart != null ? editPart.canDelete() : false;
        }

        private LayoutElementEditPart getLayoutEditPart() {
            EditPart part;
            OutLineTreeEditPart editPart;
            StructuredSelection sel;
            if (LayoutOutLinePage.this.selection instanceof StructuredSelection && (sel = (StructuredSelection)LayoutOutLinePage.this.selection) != null && !sel.isEmpty() && sel.getFirstElement() instanceof EditPart && (editPart = (OutLineTreeEditPart)sel.getFirstElement()).getWidget() instanceof TreeItem && (part = editPart.getLayoutEditPart()) instanceof LayoutElementEditPart) {
                return (LayoutElementEditPart)part;
            }
            return null;
        }

        public void run() {
            if (this.canEdit()) {
                StructuredSelection sel = (StructuredSelection)LayoutOutLinePage.this.selection;
                OutLineTreeEditPart editPart = (OutLineTreeEditPart)sel.getFirstElement();
                org.eclipse.swt.graphics.Rectangle rec = ((TreeItem)editPart.getWidget()).getBounds();
                Rectangle area = new Rectangle(rec.x, rec.y, rec.width, rec.height);
                GraphicalEditPart layoutEditpart = (GraphicalEditPart)editPart.getLayoutEditPart();
                if (layoutEditpart != null && layoutEditpart.getParent() != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (layoutEditpart.getAdapter((Class)clazz) != null) {
                        new IdDirectEditmanger(layoutEditpart, (Composite)LayoutOutLinePage.this.getViewer().getControl(), (CellEditorLocator)new TextCellEditorLocator(area)).show();
                    }
                }
            }
        }
    }

    private class OutlineContextMenuProvider
    extends ContextMenuProvider {
        private ActionRegistry actionRegistry;

        public OutlineContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
            super(viewer);
            this.actionRegistry = registry;
        }

        public void buildContextMenu(IMenuManager menu) {
            LayoutOutLinePage.this.updateDeleteActions(this.actionRegistry);
            GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
            IAction undoAction = this.actionRegistry.getAction((Object)ActionFactory.UNDO.getId());
            menu.appendToGroup("org.eclipse.gef.group.edit", undoAction);
            IAction redoAction = this.actionRegistry.getAction((Object)ActionFactory.REDO.getId());
            menu.appendToGroup("org.eclipse.gef.group.edit", redoAction);
            if (LayoutOutLinePage.this.directEdit.canDelete()) {
                menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)new Separator());
                IAction delAction = this.actionRegistry.getAction((Object)ActionFactory.DELETE.getId());
                menu.appendToGroup("org.eclipse.gef.group.edit", delAction);
            }
            if (LayoutOutLinePage.this.directEdit.canEdit()) {
                menu.add((IAction)LayoutOutLinePage.this.directEdit);
            }
        }
    }
}

