/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Container;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.ui.editors.layout.commands.DelBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Color;

public class MaskatComponentEditPolicy
extends ComponentEditPolicy {
    private boolean defaultOpaque = false;
    private Color defaultBgColor = null;

    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        Object model = this.getHost().getModel();
        if (model instanceof Component) {
            Component comp = (Component)model;
            if (comp instanceof Layout) {
                return null;
            }
            EditPart part = this.getHost();
            if (part instanceof LayoutElementEditPart && !((LayoutElementEditPart)part).canDelete()) {
                return null;
            }
            return new DelBasicDefCommand(comp.getParent(), (MaskatElement)comp);
        }
        return null;
    }

    protected boolean canFeedbackToRequest(Request request) {
        Object model = this.getHost().getModel();
        return model instanceof Container && !(model instanceof Layout);
    }

    public void showTargetFeedback(Request request) {
        if (this.canFeedbackToRequest(request)) {
            boolean doHighlight = false;
            if (request instanceof CreateRequest || request instanceof ChangeBoundsRequest) {
                doHighlight = true;
            }
            if (doHighlight) {
                Color bgColor = ((AbstractGraphicalEditPart)this.getHost()).getFigure().getBackgroundColor();
                if (bgColor != null && !bgColor.equals((Object)ColorConstants.lightGray)) {
                    this.defaultBgColor = ((AbstractGraphicalEditPart)this.getHost()).getFigure().getBackgroundColor();
                    this.defaultOpaque = ((AbstractGraphicalEditPart)this.getHost()).getFigure().isOpaque();
                }
                ((AbstractGraphicalEditPart)this.getHost()).getFigure().setBackgroundColor(ColorConstants.lightGray);
                ((AbstractGraphicalEditPart)this.getHost()).getFigure().setOpaque(true);
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.canFeedbackToRequest(request) && (request instanceof CreateRequest || request instanceof ChangeBoundsRequest)) {
            if (this.defaultBgColor != null) {
                ((AbstractGraphicalEditPart)this.getHost()).getFigure().setBackgroundColor(this.defaultBgColor);
            } else {
                ((AbstractGraphicalEditPart)this.getHost()).getFigure().setBackgroundColor(ColorConstants.white);
            }
            ((AbstractGraphicalEditPart)this.getHost()).getFigure().setOpaque(this.defaultOpaque);
        }
        super.eraseTargetFeedback(request);
    }

    public EditPolicy cloneEditPolicy() {
        MaskatComponentEditPolicy editPolicy = new MaskatComponentEditPolicy();
        editPolicy.setHost(this.getHost());
        return editPolicy;
    }
}

