/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditor;
import jp.sf.maskat.ui.editors.layout.commands.AddBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteComponentAction
extends SelectionAction {
    private LayoutElement targetDef = null;
    private LayoutGraphicalEditor editor = null;
    static /* synthetic */ Class class$0;

    public PasteComponentAction(LayoutGraphicalEditor editor) {
        super((IWorkbenchPart)editor);
        this.editor = editor;
        this.setId(ActionFactory.PASTE.getId());
        this.setText(GEFMessages.PasteAction_Label);
        this.setToolTipText(GEFMessages.PasteAction_Tooltip);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    protected boolean calculateEnabled() {
        if (!this.checkClipboard()) {
            return false;
        }
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return false;
        }
        if (objects.size() > 1) {
            return false;
        }
        Object selectedObj = objects.get(0);
        if (!(selectedObj instanceof EditPart)) {
            return false;
        }
        Object model = ((EditPart)selectedObj).getModel();
        if (!(model instanceof LayoutElement)) {
            return false;
        }
        this.targetDef = (LayoutElement)model;
        List basicDefList = (List)Clipboard.getDefault().getContents();
        return this.canBePasted(basicDefList);
    }

    private boolean checkClipboard() {
        Object clipboardContent = Clipboard.getDefault().getContents();
        if (!(clipboardContent instanceof List)) {
            return false;
        }
        int i = 0;
        while (i < ((List)clipboardContent).size()) {
            if (!(((List)clipboardContent).get(i) instanceof MaskatElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        LayoutElement def;
        if (!this.checkClipboard()) {
            return;
        }
        Command command = null;
        List basicDefList = (List)Clipboard.getDefault().getContents();
        ArrayList<LayoutElement> source = new ArrayList<LayoutElement>();
        Iterator it = basicDefList.iterator();
        while (it.hasNext()) {
            def = (LayoutElement)it.next();
            try {
                LayoutElement clone = (LayoutElement)def.clone();
                source.add(clone);
            }
            catch (CloneNotSupportedException e) {
                MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("layout.cmd.msg.error.title"), (String)Messages.getString("layout.cmd.paste.msg.error"));
                MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
                return;
            }
        }
        it = source.iterator();
        while (it.hasNext()) {
            def = (LayoutElement)it.next();
            if (def instanceof Component && this.targetDef instanceof Component) {
                Component compDef = (Component)def;
                if (compDef instanceof DynaComponent) {
                    Component comp;
                    DynaComponentClass dynaClass = (DynaComponentClass)((DynaComponent)compDef).getDynaClass();
                    if (dynaClass.isTopMovable()) {
                        comp = (Component)this.targetDef;
                        if (!(comp instanceof Layout)) {
                            int childTop;
                            int parentHeight = comp.getHeight();
                            int height = parentHeight < (childTop = compDef.getTop() + compDef.getHeight() + 10) ? parentHeight / 2 : childTop;
                            compDef.setTop(height);
                        } else {
                            compDef.setTop(compDef.getTop() + 10);
                        }
                    }
                    if (dynaClass.isLeftMovable()) {
                        comp = (Component)this.targetDef;
                        if (!(comp instanceof Layout)) {
                            int childLeft;
                            int parentWidth = comp.getWidth();
                            int width = parentWidth < (childLeft = compDef.getLeft() + compDef.getWidth() + 10) ? parentWidth / 2 : childLeft;
                            compDef.setLeft(width);
                        } else {
                            compDef.setLeft(compDef.getLeft() + 10);
                        }
                    }
                } else {
                    compDef.setLeft(compDef.getLeft() + 10);
                    compDef.setTop(compDef.getTop() + 10);
                }
            }
            command = command == null ? this.genCommand(this.targetDef, def) : command.chain(this.genCommand(this.targetDef, def));
        }
        this.execute(command);
        ArrayList<Object> toCopy = new ArrayList<Object>();
        Iterator it2 = source.iterator();
        while (it2.hasNext()) {
            LayoutElement def2 = (LayoutElement)it2.next();
            try {
                toCopy.add(def2.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        if (this.canBePasted(toCopy)) {
            Clipboard.getDefault().setContents(toCopy);
        } else {
            this.refresh();
        }
    }

    private Command genCommand(LayoutElement parentDef, LayoutElement childDef) {
        return new AddBasicDefCommand((MaskatElement)this.targetDef, (MaskatElement)childDef);
    }

    private boolean canBePasted(List basicDefList) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GraphicalViewer viewer = (GraphicalViewer)this.editor.getAdapter(clazz);
        ArrayList<GraphicalEditPart> sourceEPList = new ArrayList<GraphicalEditPart>();
        Iterator it = basicDefList.iterator();
        while (it.hasNext()) {
            LayoutElement def = (LayoutElement)it.next();
            GraphicalEditPart ep = (GraphicalEditPart)viewer.getEditPartFactory().createEditPart(null, (Object)def);
            ep.setModel((Object)def);
            FigureCanvas canvas = (FigureCanvas)viewer.getControl();
            Rectangle rec = canvas.getViewport().getBounds();
            ep.getFigure().setBounds(new Rectangle(rec.width, rec.height, 0, 0));
            sourceEPList.add(ep);
        }
        List objects = this.getSelectedObjects();
        EditPart targetEP = (EditPart)objects.get(0);
        if (targetEP instanceof LayoutElementEditPart) {
            int i = 0;
            while (i < sourceEPList.size()) {
                if (!((LayoutElementEditPart)targetEP).canAddChild(((EditPart)sourceEPList.get(i)).getModel())) {
                    return false;
                }
                EditPart sourceEditPart = (EditPart)sourceEPList.get(i);
                if (sourceEditPart instanceof LayoutElementEditPart && !((LayoutElementEditPart)sourceEditPart).canAddParent(targetEP.getModel())) {
                    return false;
                }
                ++i;
            }
        }
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"add children");
        request.setEditParts(sourceEPList);
        Command command = targetEP.getCommand((Request)request);
        return command == null ? false : command.canExecute();
    }
}

