/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout;

import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.MaskatResources;
import jp.sf.maskat.ui.editors.layout.PluggablePaletteCustomizer;
import jp.sf.maskat.ui.editors.layout.actions.CopyComponentAction;
import jp.sf.maskat.ui.editors.layout.actions.CutComponentAction;
import jp.sf.maskat.ui.editors.layout.actions.PasteComponentAction;
import jp.sf.maskat.ui.editors.layout.editparts.ChainedEditPartFactory;
import jp.sf.maskat.ui.editors.layout.outline.LayoutOutLinePage;
import jp.sf.maskat.ui.views.properties.tabbed.TabbedEventPropertySheetPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class LayoutGraphicalEditor
extends GraphicalEditorWithFlyoutPalette
implements ITabbedPropertySheetPageContributor,
IResourceChangeListener {
    public static final String EDITOR_ID = "jp.sf.maskat.ui.layoutGraphicalEditor";
    protected MaskatResources data;
    private LayoutOutLinePage outlinePage = null;
    private PluggablePaletteCustomizer customizer;
    private IProject project;
    private boolean saving = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public LayoutGraphicalEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.customizer == null) {
            this.customizer = new PluggablePaletteCustomizer();
        }
        return this.customizer.getPaletteRoot();
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        MaskatNature nature = MaskatNature.getNature(this.project);
        if (nature != null) {
            int gridXSize;
            boolean isGrid = nature.getGridSelection();
            boolean isToGrid = nature.getSnapToGridSelection();
            boolean isToObj = nature.getSnapToGeometrySelection();
            int gridYSize = gridXSize = nature.getGridSize();
            viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridXSize, gridYSize));
            viewer.setProperty("SnapToGeometry.isEnabled", (Object)isToObj);
            viewer.setProperty("SnapToGrid.isEnabled", (Object)isToGrid);
            viewer.setProperty("SnapToGrid.isVisible", (Object)isGrid);
            this.genContextMenu(isGrid, isToGrid, isToObj);
        } else {
            this.genContextMenu(false, false, false);
        }
        if (viewer.getEditDomain().getPaletteViewer() != null) {
            viewer.getEditDomain().getPaletteViewer().setCustomizer((PaletteCustomizer)this.customizer);
        } else {
            try {
                this.getSite().getPage().showView("org.eclipse.gef.ui.palette_view");
            }
            catch (PartInitException e) {
                MaskatUIPlugin.log(e.getStatus());
            }
        }
        viewer.setContents((Object)this.data.getLayout());
    }

    protected void genContextMenu(boolean isGrid, boolean isToGrid, boolean isToObj) {
        final GraphicalViewer viewer = this.getGraphicalViewer();
        MenuManager mm = viewer.getContextMenu();
        if (mm == null) {
            mm = new MenuManager();
            viewer.setContextMenu(mm);
        }
        mm.removeAll();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        mm.add((IAction)ActionFactory.UNDO.create(window));
        mm.add((IAction)ActionFactory.REDO.create(window));
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)ActionFactory.CUT.create(window));
        mm.add((IAction)ActionFactory.COPY.create(window));
        mm.add((IAction)ActionFactory.PASTE.create(window));
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)ActionFactory.DELETE.create(window));
        mm.add((IContributionItem)new Separator());
        MenuManager smm = new MenuManager(Messages.getString("layout.contextmenu.alignmenu"));
        ActionRegistry registry = this.getActionRegistry();
        Iterator ite = registry.getActions();
        while (ite.hasNext()) {
            Object action = ite.next();
            if (!(action instanceof AlignmentAction)) continue;
            smm.add((IAction)action);
        }
        mm.add((IContributionItem)smm);
        boolean isSnapGrid = isToGrid;
        Action snapToGridAction = new Action(Messages.getString("layout.contextmenu.snaptogrid"), 8, isSnapGrid){
            private boolean selected;
            {
                this.selected = bl;
            }

            public void run() {
                boolean checked = this.isChecked();
                if (this.selected && this.isChecked()) {
                    checked = false;
                    this.setChecked(checked);
                }
                this.selected = checked;
                viewer.setProperty("SnapToGrid.isEnabled", (Object)checked);
                LayoutGraphicalEditor.this.storeGridSelection("snapToGrid", this.isChecked());
            }
        };
        boolean isSnapObj = isToObj;
        Action snapToGeometryAction = new Action(Messages.getString("layout.contextmenu.snaptogeometry"), 8, isSnapObj){
            private boolean selected;
            {
                this.selected = bl;
            }

            public void run() {
                boolean checked = this.isChecked();
                if (this.selected && this.isChecked()) {
                    checked = false;
                    this.setChecked(checked);
                }
                this.selected = checked;
                viewer.setProperty("SnapToGeometry.isEnabled", (Object)this.isChecked());
                LayoutGraphicalEditor.this.storeGridSelection("snapToObj", this.isChecked());
            }
        };
        Action viewGridAction = new Action(Messages.getString("layout.contextmenu.grid"), 2, (IAction)snapToGridAction, viewer){
            private final /* synthetic */ IAction val$snapToGridAction;
            private final /* synthetic */ GraphicalViewer val$viewer;
            {
                this.val$snapToGridAction = iAction;
                this.val$viewer = graphicalViewer;
            }

            public void run() {
                this.val$snapToGridAction.setEnabled(this.isChecked());
                if (!this.isChecked()) {
                    this.val$viewer.setProperty("SnapToGrid.isEnabled", (Object)Boolean.FALSE);
                } else if (this.val$snapToGridAction.isChecked()) {
                    this.val$viewer.setProperty("SnapToGrid.isEnabled", (Object)Boolean.TRUE);
                }
                this.val$viewer.setProperty("SnapToGrid.isVisible", (Object)this.isChecked());
                LayoutGraphicalEditor.this.storeGridSelection("gridView", this.isChecked());
            }
        };
        Action upGridAction = new Action(Messages.getString("layout.contextmenu.gridsize.up"), 1){

            public void run() {
                Dimension d = (Dimension)viewer.getProperty("SnapToGrid.GridSpacing");
                Dimension n = new Dimension(d.width + 2, d.height + 2);
                viewer.setProperty("SnapToGrid.GridSpacing", (Object)n);
                LayoutGraphicalEditor.this.storeGridSize(n.width);
            }
        };
        Action downGridAction = new Action(Messages.getString("layout.contextmenu.gridsize.down"), 1){

            public void run() {
                Dimension d = (Dimension)viewer.getProperty("SnapToGrid.GridSpacing");
                Dimension n = new Dimension(d.width > 0 ? d.width - 2 : 0, d.height > 0 ? d.height - 2 : 0);
                viewer.setProperty("SnapToGrid.GridSpacing", (Object)n);
                LayoutGraphicalEditor.this.storeGridSize(n.width);
            }
        };
        Action baseGridAction = new Action(Messages.getString("layout.contextmenu.gridsize.standard"), 1){

            public void run() {
                int size = Integer.parseInt("15");
                viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(size, size));
                LayoutGraphicalEditor.this.storeGridSize(Integer.parseInt("15"));
            }
        };
        snapToGridAction.setChecked(isToGrid);
        snapToGridAction.setEnabled(isGrid);
        snapToGeometryAction.setChecked(isToObj);
        viewGridAction.setChecked(isGrid);
        MenuManager gridMenu = new MenuManager(Messages.getString("layout.contextmenu.gridmenu"));
        gridMenu.add((IAction)viewGridAction);
        gridMenu.add((IAction)snapToGridAction);
        gridMenu.add((IAction)snapToGeometryAction);
        gridMenu.add((IContributionItem)new Separator());
        MenuManager sizeMenu = new MenuManager(Messages.getString("layout.contextmenu.gridsize"));
        sizeMenu.add((IAction)upGridAction);
        sizeMenu.add((IAction)downGridAction);
        sizeMenu.add((IContributionItem)new Separator());
        sizeMenu.add((IAction)baseGridAction);
        gridMenu.add((IContributionItem)sizeMenu);
        mm.add((IContributionItem)gridMenu);
        mm.add((IContributionItem)new Separator());
        Action showPropertiesViewAction = new Action(Messages.getString("layout.contextmenu.showproperties")){

            public void run() {
                try {
                    LayoutGraphicalEditor.this.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException e) {
                    MaskatUIPlugin.log(e.getStatus());
                }
            }
        };
        mm.add((IAction)showPropertiesViewAction);
        mm.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu("#layoutGraphicalEditor", mm, this.getSite().getSelectionProvider());
    }

    private void storeGridSelection(String propertyName, boolean value) {
        MaskatNature nature = MaskatNature.getNature(this.project);
        if ("gridView".equals(propertyName)) {
            nature.setGridSelection(value);
        } else if ("snapToGrid".equals(propertyName)) {
            if (value) {
                nature.setSnapToGeometrySelection(false);
            }
            nature.setSnapToGridSelection(value);
        } else if ("snapToObj".equals(propertyName)) {
            if (value) {
                nature.setSnapToGridSelection(false);
            }
            nature.setSnapToGeometrySelection(value);
        }
        try {
            nature.getPreferenceStore().save();
        }
        catch (IOException e) {
            Status status = new Status(4, "jp.sf.maskat.ui", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            MaskatUIPlugin.log((IStatus)status);
        }
    }

    private void storeGridSize(int size) {
        MaskatNature nature = MaskatNature.getNature(this.project);
        nature.setGridSize(size);
        try {
            nature.getPreferenceStore().save();
        }
        catch (IOException e) {
            Status status = new Status(4, "jp.sf.maskat.ui", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            MaskatUIPlugin.log((IStatus)status);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        try {
            try {
                this.saving = true;
                this.data.save();
                this.getCommandStack().markSaveLocation();
                this.firePropertyChange(257);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("layout.editor.save.error.title"), (String)Messages.getString("layout.editor.save.msg.error"), (IStatus)e.getStatus());
                MaskatUIPlugin.log(e.getStatus());
            }
            catch (Exception e) {
                Status status = new Status(4, "jp.sf.maskat.ui", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("layout.editor.save.error.title"), (String)Messages.getString("layout.editor.save.msg.error"));
                MaskatUIPlugin.log((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.saving = false;
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.saving = false;
            return;
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.firePropertyChange(257);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new ChainedEditPartFactory());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        site.getKeyBindingService();
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void setInput(IEditorInput input) {
        IFile layoutXmlFile;
        super.setInput(input);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((layoutXmlFile = (IFile)input.getAdapter((Class)clazz)) != null) {
            this.setPartName(layoutXmlFile.getName());
            this.project = layoutXmlFile.getProject();
        }
        this.data = new MaskatResources(layoutXmlFile);
        try {
            this.data.load();
        }
        catch (CoreException e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 0, Messages.getString("layout.editor.load.msg.error"), (Throwable)e));
        }
        catch (Exception e) {
            Status status = new Status(4, "jp.sf.maskat.ui", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            MaskatUIPlugin.log((IStatus)status);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor()) || ((Object)((Object)this)).equals(part)) {
            this.updateActions(this.getSelectionActions());
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new TabbedEventPropertySheetPage(this);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(type)) {
            this.outlinePage = new LayoutOutLinePage(this);
            this.getSelectionSynchronizer().addViewer(this.outlinePage.getViewer());
            return this.outlinePage;
        }
        return super.getAdapter(type);
    }

    public String getContributorId() {
        return EDITOR_ID;
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyComponentAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CutComponentAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteComponentAction(this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            delta = delta.findMember(this.data.getLayoutXMLFile().getFullPath());
        }
        if (delta != null && !this.saving) {
            switch (delta.getKind()) {
                case 4: {
                    this.setInput(this.getEditorInput());
                    this.getGraphicalViewer().setContents((Object)this.data.getLayout());
                    if (this.outlinePage != null) {
                        this.outlinePage.update();
                    }
                    this.getCommandStack().flush();
                    break;
                }
                case 2: {
                    this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
                }
            }
        }
    }
}

