/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "jp.sf.maskat.ui.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("jp.sf.maskat.ui.messages");

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static String format(String key, Object[] arguments) {
        try {
            String pattern = RESOURCE_BUNDLE.getString(key);
            if (arguments == null || arguments.length == 0) {
                return pattern;
            }
            return MessageFormat.format(pattern, arguments);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static String format(String key, boolean argument) {
        return Messages.format(key, (Object)argument);
    }

    public static String format(String key, short argument) {
        return Messages.format(key, new Short(argument));
    }

    public static String format(String key, int argument) {
        return Messages.format(key, new Integer(argument));
    }

    public static String format(String key, long argument) {
        return Messages.format(key, new Long(argument));
    }

    public static String format(String key, float argument) {
        return Messages.format(key, new Float(argument));
    }

    public static String format(String key, double argument) {
        return Messages.format(key, new Double(argument));
    }

    public static String format(String key, Object argument) {
        return Messages.format(key, new Object[]{argument});
    }

    private Messages() {
    }
}

