/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui;

import jp.sf.maskat.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class LayoutEditorDialogArea
extends Composite {
    private Button gridView;
    private Button noSnap;
    private Button snapToGrid;
    private Button snapToObj;
    private Spinner gridSize;
    private boolean valid;
    private String errorMessage;

    public LayoutEditorDialogArea(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        Group layoutGroup = new Group((Composite)this, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 5;
        layoutGroup.setLayout((Layout)layout);
        layoutGroup.setLayoutData((Object)new GridData(1808));
        layoutGroup.setText(Messages.getString("property.layout.group.title"));
        this.gridView = new Button((Composite)layoutGroup, 131104);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.gridView.setLayoutData((Object)gridData);
        this.gridView.setText(Messages.getString("property.layout.grid"));
        Label betweenLabel = new Label((Composite)layoutGroup, 131072);
        GridData betweenData = new GridData(768);
        betweenData.horizontalSpan = 1;
        betweenLabel.setLayoutData((Object)betweenData);
        betweenLabel.setText(Messages.getString("property.layout.gridspan"));
        this.gridSize = new Spinner((Composite)layoutGroup, 2048);
        this.gridSize.setMinimum(1);
        this.gridSize.setMaximum(100);
        this.gridSize.setSelection(15);
        this.gridSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LayoutEditorDialogArea.this.validatePage();
                LayoutEditorDialogArea.this.setValid(LayoutEditorDialogArea.this.validatePage());
            }
        });
        Group snapGroup = new Group((Composite)layoutGroup, 0);
        GridLayout snapLayout = new GridLayout(1, false);
        snapLayout.marginLeft = 5;
        snapGroup.setLayout((Layout)snapLayout);
        snapGroup.setLayoutData((Object)new GridData(768));
        snapGroup.setText(Messages.getString("property.layout.label.snap"));
        this.noSnap = new Button((Composite)snapGroup, 16);
        this.noSnap.setText(Messages.getString("property.layout.label.nosnap"));
        this.snapToGrid = new Button((Composite)snapGroup, 16);
        this.snapToGrid.setText(Messages.getString("property.layout.label.snapTogrid"));
        this.snapToObj = new Button((Composite)snapGroup, 16);
        this.snapToObj.setText(Messages.getString("property.layout.label.snapToobj"));
    }

    private boolean validatePage() {
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String newMessage) {
        this.errorMessage = newMessage;
    }

    public void setGridSelection(boolean v) {
        this.gridView.setSelection(v);
    }

    public boolean getGridSelection() {
        return this.gridView.getSelection();
    }

    public void setSnapToGridSelection(boolean v) {
        this.snapToGrid.setSelection(v);
        if (v) {
            this.noSnap.setSelection(false);
            this.snapToObj.setSelection(false);
        } else if (!this.snapToObj.getSelection()) {
            this.noSnap.setSelection(true);
        }
    }

    public boolean getSnapToGridSelection() {
        return this.snapToGrid.getSelection();
    }

    public void setSnapToObjectSelection(boolean v) {
        this.snapToObj.setSelection(v);
        if (v) {
            this.noSnap.setSelection(false);
            this.snapToGrid.setSelection(false);
        } else if (!this.snapToGrid.getSelection()) {
            this.noSnap.setSelection(true);
        }
    }

    public boolean getSnapToObjectSelection() {
        return this.snapToObj.getSelection();
    }

    public void setGridSize(int v) {
        this.gridSize.setSelection(v);
    }

    public int getGridSize() {
        return this.gridSize.getSelection();
    }
}

