/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.ui.editors.layout.commands.AddComponentCommand;
import jp.sf.maskat.ui.editors.layout.commands.ChangeConstraintCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import jp.sf.maskat.widget.rialto.editpart.DivSplitEditPart;
import jp.sf.maskat.widget.rialto.editpart.SplitLineEditPart;
import jp.sf.maskat.widget.rialto.editpolicy.SplitterLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.figure.SplitterFigure;
import org.apache.commons.beanutils.DynaClass;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;

public class SplitterEditPart
extends ComponentEditPart
implements HorizontalResizable,
VerticalResizable {
    private DivSplitEditPart firstPart = null;
    private DivSplitEditPart secondPart = null;
    private SplitLineEditPart lineEditPart = null;

    protected IFigure createFigure() {
        return new SplitterFigure();
    }

    protected void refreshVisuals() {
        Component comp = (Component)this.getModel();
        Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), comp.getHeight());
        GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
        if (parent != null) {
            parent.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    protected List getModelChildren() {
        List result = null;
        if (this.getModel() instanceof MaskatElement) {
            result = ((MaskatElement)this.getModel()).getChildren();
        }
        return result != null ? result : super.getModelChildren();
    }

    private SplitLineEditPart getSplitLineEditPart() {
        if (this.lineEditPart == null) {
            this.lineEditPart = new SplitLineEditPart(this.getModel());
        }
        return this.lineEditPart;
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.addChild((EditPart)this.getSplitLineEditPart(), -1);
        if (this.firstPart == null) {
            List children = this.getChildren();
            int i = 0;
            while (i < children.size()) {
                Object obj = children.get(i);
                if (obj instanceof DivSplitEditPart) {
                    if (this.firstPart == null) {
                        this.firstPart = (DivSplitEditPart)((Object)obj);
                        this.firstPart.setIndex(0);
                        this.firstPart.refreshVisuals();
                    } else {
                        this.secondPart = (DivSplitEditPart)((Object)obj);
                        this.secondPart.setIndex(1);
                        this.secondPart.refreshVisuals();
                    }
                }
                ++i;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("prop".equals(evt.getPropertyName()) || "orientation".equals(evt.getPropertyName())) {
            this.refreshVisuals();
            this.setDivSplitVisible(true);
            this.refreshDivSplites();
            this.getViewer().select((EditPart)this);
        } else if ("constraint".equals(evt.getPropertyName())) {
            this.refreshDivSplites();
        } else if ("width".equals(evt.getPropertyName())) {
            this.refreshDivSplites();
        } else if ("height".equals(evt.getPropertyName())) {
            this.refreshDivSplites();
        }
        super.propertyChange(evt);
    }

    public void setDivSplitVisible(boolean visible) {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof DivSplitEditPart) {
                ((DivSplitEditPart)((Object)obj)).getFigure().setVisible(visible);
            }
            ++i;
        }
    }

    public void refreshSelectedWidget(ComponentEditPart child) {
        if (this.getParent() instanceof ComponentEditPart) {
            ((ComponentEditPart)this.getParent()).refreshSelectedWidget((ComponentEditPart)this);
        }
        this.refreshVisuals();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        int style = FeedBackComponentEditPolicy.getStyle((EditPart)this);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SplitterLayoutEditPolicy(style));
    }

    public Command createConstrainCommand(Object model, Rectangle constraint) {
        if (model instanceof Component) {
            return new ChangeConstraintCommand((Component)model, constraint);
        }
        if (model == SplitLineEditPart.SPLITLINE_MODEL) {
            return new ChangeConstraintCommand((Component)model, constraint);
        }
        return null;
    }

    private void refreshDivSplites() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof DivSplitEditPart) {
                ((DivSplitEditPart)((Object)obj)).refreshVisuals();
            } else if (obj instanceof SplitLineEditPart) {
                ((SplitLineEditPart)((Object)obj)).refreshVisuals();
            }
            ++i;
        }
    }

    public Command getCreateCommand(Object parent, Object node) {
        Component widget = (Component)node;
        if (widget.getChildren().size() <= 0) {
            DynaComponentClass dynaClass = (DynaComponentClass)((DynaComponent)this.getModel()).getDynaClass();
            ComponentLibrary library = dynaClass.getLibrary();
            DynaComponentClass divClass = (DynaComponentClass)ComponentRegistry.getComponentType((String)library.getNamespaceURI(), (String)"divSplit");
            DynaComponent divFirst = new DynaComponent((DynaClass)divClass);
            DynaComponent divSecond = new DynaComponent((DynaClass)divClass);
            divFirst.setName("divNew");
            divSecond.setName("divNew1");
            ComponentUtils.setUniqueName((Layout)((Component)parent).getLayout(), (Component)divFirst);
            ComponentUtils.setUniqueName((Layout)((Component)parent).getLayout(), (Component)divSecond);
            widget.addChild((Object)divFirst);
            widget.addChild((Object)divSecond);
        }
        return new AddComponentCommand((Component)parent, widget);
    }

    public boolean canAddChild(Object widget) {
        return false;
    }

    public double getProp() {
        return (Double)((DynaComponent)this.getModel()).get("prop");
    }

    public void setProp(double prop) {
        ((DynaComponent)this.getModel()).set("prop", (Object)new Double(prop));
    }

    public String getOrientation() {
        return (String)((DynaComponent)this.getModel()).get("orientation");
    }
}

