/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.editpart;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.editors.layout.commands.SetPropertyCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.widget.rialto.editpart.SplitterEditPart;
import jp.sf.maskat.widget.rialto.editpolicy.SplitLineComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.SplitLineFeedBackEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.SplitLineLayoutPolicy;
import jp.sf.maskat.widget.rialto.figure.SplitLineFigure;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;

public class SplitLineEditPart
extends ComponentEditPart {
    public static final Object SPLITLINE_MODEL = new Object();

    public SplitLineEditPart(Object model) {
        this.setModel(SPLITLINE_MODEL);
    }

    protected IFigure createFigure() {
        SplitLineFigure figure = new SplitLineFigure();
        figure.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseExited(MouseEvent me) {
                SplitterEditPart parent = (SplitterEditPart)SplitLineEditPart.this.getParent();
                parent.setDivSplitVisible(true);
                SplitLineFigure figure = (SplitLineFigure)SplitLineEditPart.this.getFigure();
                if (figure.isMouseMoveing()) {
                    figure.setMouseMoveing(false);
                    parent.getViewer().select((EditPart)parent);
                }
            }
        });
        figure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                SplitterEditPart parent = (SplitterEditPart)SplitLineEditPart.this.getParent();
                parent.setDivSplitVisible(false);
                SplitLineFigure figure = (SplitLineFigure)SplitLineEditPart.this.getFigure();
                figure.setMouseMoveing(true);
            }
        });
        return figure;
    }

    protected void refreshVisuals() {
        SplitterEditPart editPart = (SplitterEditPart)this.getParent();
        Component parent = (Component)editPart.getModel();
        Rectangle lineConstraint = null;
        if ("h".equals(editPart.getOrientation())) {
            int x = (int)((double)parent.getWidth() * editPart.getProp()) - 2;
            lineConstraint = new Rectangle(x, 0, 5, parent.getHeight() - 1);
            this.getFigure().setCursor(Cursors.SIZEWE);
        } else {
            int y = (int)((double)parent.getHeight() * editPart.getProp()) - 2;
            lineConstraint = new Rectangle(0, y, parent.getWidth() - 2, 5);
            this.getFigure().setCursor(Cursors.SIZENS);
        }
        editPart.getFigure().setConstraint(this.getFigure(), (Object)lineConstraint);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new SplitLineFeedBackEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new SplitLineComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SplitLineLayoutPolicy());
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        if ("PrimaryDrag Policy".equals(key) && !(editPolicy instanceof SplitLineFeedBackEditPolicy)) {
            return;
        }
        super.installEditPolicy(key, editPolicy);
    }

    public Command createConstrainCommand(Object model, Rectangle constraint) {
        if (model == SPLITLINE_MODEL) {
            Component parent = (Component)this.getParent().getModel();
            String orientation = ((SplitterEditPart)this.getParent()).getOrientation();
            double value = 0.0;
            value = "h".equals(orientation) ? (parent.getWidth() == 0 ? 0.0 : (double)constraint.x / (double)parent.getWidth()) : (parent.getHeight() == 0 ? 0.0 : (double)constraint.y / (double)parent.getHeight());
            double prop = (double)Math.round(value * 1000.0) / 1000.0;
            return new SetPropertyCommand((Object)parent, "prop", (Object)new Double(prop));
        }
        return null;
    }

    public boolean canAddParent(Object parent) {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDelete() {
        return false;
    }
}

