/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.widget.rialto.commands;

import java.util.ArrayList;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.LayoutElement;
import org.eclipse.gef.commands.Command;

public class DelRadioCommand
extends Command {
    private MaskatElement parent;
    private MaskatElement child;
    private int index;
    private EventDef eventDef;
    private jp.sf.maskat.core.event.Component eventComponent;
    private boolean noAction = false;
    private LayoutElement radioGroup;
    private LayoutElement radioMember;
    private LayoutElement layout;

    public DelRadioCommand(MaskatElement parent, MaskatElement child) {
        this.parent = parent;
        this.child = child;
        this.radioGroup = null;
        this.radioMember = null;
        this.layout = null;
        if (child instanceof Component) {
            this.setRemoveReference(((Component)child).getName());
        }
    }

    public void execute() {
        this.index = this.parent.getChildIdx((Object)this.child);
        this.parent.removeChild((Object)this.child);
        if (this.child instanceof Component) {
            Component component = (Component)this.child;
            this.eventDef = component.getLayout().getLayoutDef().getEventDef();
            this.eventComponent = this.eventDef.findComponent(component.getName());
            if (this.eventComponent != null) {
                this.eventDef.removeChild((Object)this.eventComponent);
            }
        }
        if (this.radioGroup != null && this.radioMember != null) {
            this.radioGroup.removeChild((Object)this.radioMember);
            if (this.radioGroup.getChildren().size() == 0) {
                this.layout = this.radioGroup.getLayout();
                this.layout.removeChild((Object)this.radioGroup);
            }
        }
    }

    public void undo() {
        if (this.noAction) {
            return;
        }
        if (this.radioGroup != null && this.radioMember != null) {
            if (this.layout != null) {
                this.layout.addChildToIdx((Object)this.radioGroup, 0);
            }
            this.radioGroup.addChild((Object)this.radioMember);
        }
        this.parent.addChildToIdx((Object)this.child, this.index);
        if (this.eventDef != null && this.eventComponent != null) {
            this.eventDef.addChild((Object)this.eventComponent);
        }
    }

    public boolean canUndo() {
        return true;
    }

    private void setRemoveReference(String name) {
        List radioGroups = this.getRadioGroups();
        int i = 0;
        while (i < radioGroups.size()) {
            DynaComponent group = (DynaComponent)radioGroups.get(i);
            List children = group.getTypedChildren("radioMember");
            int j = 0;
            while (j < children.size()) {
                DynaComponent member = (DynaComponent)children.get(j);
                if (name.equals(member.get("ref"))) {
                    this.radioGroup = group;
                    this.radioMember = member;
                }
                ++j;
            }
            ++i;
        }
    }

    private List getRadioGroups() {
        ArrayList<DynaComponent> result = new ArrayList<DynaComponent>();
        DynaComponent comp = (DynaComponent)this.child;
        List children = comp.getLayout().getChildren();
        int i = 0;
        while (i < children.size()) {
            DynaComponent dynaComponent;
            Object obj = children.get(i);
            if (obj instanceof DynaComponent && "radioGroup".equals((dynaComponent = (DynaComponent)obj).getDynaClass().getName())) {
                result.add(dynaComponent);
            }
            ++i;
        }
        return result;
    }
}

