/*
 * Copyright (c)  2006-2009 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @class イベント発生元のマスカット部品名、およびイベントの種類から、適切なコマンド集合を実行するクラスです。
 *  
 * @name maskat.control.CommandSet
 * @extends maskat.control.Command
 */ 
maskat.lang.Class.declare("maskat.control.CommandSet")
	.extend("maskat.control.Command", {

	/** @scope maskat.control.CommandSet.prototype */
	
	/**
	 * コンストラクタです。 
	 */
	initialize: function() {
		this.priorCommands = null;
		this.commands = null;
	},

	execute: function(app) {
		/* 優先コマンド (JavaScript/CSS ロード) の実行 */
		if (this.priorCommands) {
			for (var i = 0; i < this.priorCommands.length; i++) {
				this.executeCommand(app, this.priorCommands[i]);
			}
		}	

		/* 通常コマンドの実行 */
		if (this.commands) {
			for (var j = 0; j < this.commands.length; j++) {
				this.executeCommand(app, this.commands[j]);
			}
		}	
	
	},

	executeCommand: function(app, command){
		try {
			command.execute(app);
		} catch (e) {
			maskat.app.handleError(e);
		}
	}

});
