/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.action;

import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.command.DeleteTargetNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;


public class DeleteTargetNodeAction extends AbstractAction {

	private ITreeNode nodeToBeDeleted;
	
	public DeleteTargetNodeAction(TreeViewer treeViewer, ITreeNode nodeToBeDeleted) {
		super(treeViewer);
		this.nodeToBeDeleted = nodeToBeDeleted;
	}
	
	public String getText() {
		return Messages.getString("deleteOneNodeAction.deleteLabel"); //$NON-NLS-1$
	}
	
	public ImageDescriptor getImageDescriptor() {
		return null;
	}
	
	public void run() {
		ITreeNode parent = nodeToBeDeleted.getParent(); 
		EventPropertiesMasterDetailsBlock.executeCommand(
			new DeleteTargetNodeCommand(treeViewer, parent, nodeToBeDeleted));
	}
}
