/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.AddComponentCommand;
import jp.sf.maskat.ui.editors.layout.commands.OrphanChildrenCommand;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;


public class ComponentXYLayoutEditPolicy extends XYLayoutEditPolicy {

	private int feedBackStyle = FeedBackComponentEditPolicy.NONRESIZE;
	
	public ComponentXYLayoutEditPolicy() {}
	
	public ComponentXYLayoutEditPolicy(int style) {
		setFeedBackStyle(style);
	}
	
	protected Command createAddCommand(EditPart child, Object constraint) {
		Object childModel = child.getModel();

		EditPart parentEditPart = getHost();
		Object parent = parentEditPart.getModel();

		if (!(childModel instanceof Component)) {
			return null;
		}
		if (parentEditPart instanceof LayoutElementEditPart) {
			if (!(childModel instanceof LayoutElement) ||
				!((LayoutElementEditPart) parentEditPart).
					canAddChild((LayoutElement) childModel)) {
				return null;
			}
		}
		if (child instanceof LayoutElementEditPart &&
				parentEditPart instanceof EditPart &&
				!((LayoutElementEditPart) child).
					canAddParent(((EditPart) parentEditPart).getModel())) {
			return null;
		}
		AddComponentCommand command = null;
		if (isCheckConstraint((Rectangle) constraint)) {
			command = new AddComponentCommand((Component) parent, (Component) childModel);
			command.setConstraint((Rectangle) constraint);
		}
		return command;
	}

	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		Command cmd = null;
		if (child instanceof LayoutElementEditPart) {
			if (isCheckConstraint((Rectangle) constraint)) {
				LayoutElementEditPart part = (LayoutElementEditPart) child;
				cmd = part.createConstrainCommand(child.getModel(), (Rectangle) constraint);
			}
		}
		return cmd;
	}

	private boolean isCheckConstraint(Rectangle rec) {
		return !(rec.x < 0 || rec.y < 0);
	}
	
	protected Command getCreateCommand(CreateRequest request) {
		Object model = getHost().getModel();
		Command cmd = null;
		if (model instanceof Component) {
			MaskatElement host = (MaskatElement) model;
			Object node = request.getNewObject();

			EditPart editPart = getHost();
			if (editPart instanceof LayoutElementEditPart) {
				LayoutElementEditPart part = (LayoutElementEditPart) editPart;
				if (!(part.canAddChild((LayoutElement) node))) {
					return null;
				}
			}
			LayoutElementEditPart child = (LayoutElementEditPart)
				getHost().getViewer().getEditPartFactory().createEditPart(null, node);
			
			if (!child.canAddParent(editPart.getModel())) {
				return null;
			}
			cmd = child.getCreateCommand(host, node);
			
			if (cmd != null && cmd instanceof AddComponentCommand) {
				((AddComponentCommand) cmd).setConstraint((Rectangle) getConstraintFor(request));
			}
		}
		return cmd;
	}
	
	protected Command getOrphanChildrenCommand(Request request) {

		Object obj = getHost().getModel();
		if (obj instanceof Component &&
				((Component) obj).getChildren().size() > 0) {
			
		//if (obj instanceof Container) {
		
			List editParts = ((GroupRequest) request).getEditParts();
			List models = new ArrayList();
			for (int i = 0; i < editParts.size(); i++) {
				models.add(((EditPart) editParts.get(i)).getModel());
			}
			OrphanChildrenCommand command = new OrphanChildrenCommand(models);
			return command;
		}
		return null;
	}

	protected Command getDeleteDependantCommand(Request request) {
		return null;
	}

	protected Command getCloneCommand(ChangeBoundsRequest request) {
		return super.getCloneCommand(request);
	}
	
	public void setFeedBackStyle(int style) {
		feedBackStyle = style;
	}

	public int getFeedBackStyle() {
		return feedBackStyle;
	}	
	
	protected EditPolicy createChildEditPolicy(EditPart child) {
		int style = 0;
		EditPolicy policy = child.getEditPolicy(EditPolicy.LAYOUT_ROLE);
		if (policy instanceof ComponentXYLayoutEditPolicy) {
			style = ((ComponentXYLayoutEditPolicy) policy).getFeedBackStyle();
		}
		return new FeedBackComponentEditPolicy(style);
	}
}
