/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import java.net.URI;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class MaskatFrameworkDialogArea extends Composite {

    private Text maskatFWPath;
	
    private boolean valid;
	
	private String errorMessage;
	
	private IProject selectProject;
	
	public MaskatFrameworkDialogArea(IProject project, Composite parent, int style) {
		super(parent, style);
		selectProject = project;
		createControl();
	}
	
	private void createControl() {
		setLayout(new GridLayout());
		setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
        Group fwGroup = new Group(this, SWT.NONE);
        GridLayout layout = new GridLayout(4, false);
        layout.marginLeft = 5;
        fwGroup.setLayout(layout);
        fwGroup.setLayoutData(new GridData(GridData.FILL_BOTH));
        fwGroup.setText(Messages.getString("property.title")); //$NON-NLS-1$
		Label dirLabel = new Label(fwGroup, SWT.NULL);
		dirLabel.setText(Messages.getString("property.label.framework")); //$NON-NLS-1$		
		
		maskatFWPath = new Text(fwGroup, SWT.BORDER);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = 2;
		maskatFWPath.setLayoutData(gridData);
		maskatFWPath.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setValid(validatePage());
			}
		});		
		Button button = new Button(fwGroup, SWT.PUSH);
		button.setText(Messages.getString("property.browse")); //$NON-NLS-1$
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});	
	}
	
	private void handleBrowse() {
		ContainerSelectionDialog dialog = new ContainerSelectionDialog(getShell(),
				ResourcesPlugin.getWorkspace().getRoot(), true,
					Messages.getString("property.selectdialog.title")); //$NON-NLS-1$
		if (dialog.open() == Window.OK) {
			Object[] result = dialog.getResult();
			if (result.length == 1) {
				maskatFWPath.setText(((Path) result[0]).toString());
			}
		}
	}
	
	public boolean isValid() {
		return valid;
	}
	
	public void setValid(boolean valid) {
		this.valid = valid;
	}
	
	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String newMessage) {
		this.errorMessage = newMessage;
	}
	
	private boolean validatePage() {
        String path = maskatFWPath.getText();
		if (path == null || path.length() == 0) {
			setErrorMessage(Messages.getString("property.msg.error.notpath")); //$NON-NLS-1$
			maskatFWPath.setFocus();
			return false;
		}
		IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
		URI fwUrl = FileSystemSupportRegistry.getInstance()
			.getDefaultConfiguration().getContributor().getURI(path);
		IStatus fwLocationStatus = workspace.validateProjectLocationURI(selectProject, fwUrl);
		if (!fwLocationStatus.isOK()) {
			setErrorMessage(fwLocationStatus.getMessage());
			maskatFWPath.setFocus();
			return false;
		}
        setErrorMessage(null);
		return true;
	}
	
	public void setMaskatFWPath(String path) {
		maskatFWPath.setText(path);
	}
	
	public void setMaskatFWPath(IPath path) {
		maskatFWPath.setText(path.toString());
	}
	
	public String getMaskatFWPath() {
		return maskatFWPath.getText();
	}
}
