/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.VerticalResizable;

import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;

public class FeedBackComponentEditPolicy extends ResizableEditPolicy {
	public static final int HORIZONTAL = PositionConstants.EAST | PositionConstants.WEST;
	public static final int VERTICAL = PositionConstants.SOUTH | PositionConstants.NORTH;
	public static final int NONRESIZE = 0;
	
	private int style = NONRESIZE; 
	private static int[] directionList;
	private boolean move;
	
	static {
		directionList = new int[4];
		directionList[0] = PositionConstants.EAST;
		directionList[1] = PositionConstants.WEST;		
		directionList[2] = PositionConstants.SOUTH;
		directionList[3] = PositionConstants.NORTH;
	}
	
	public FeedBackComponentEditPolicy() {
		this(HORIZONTAL | VERTICAL);
	}
	
	public FeedBackComponentEditPolicy(int direction) {
		this(direction, true);
	}

	public FeedBackComponentEditPolicy(int direction, boolean move) {
		this.style = direction;
		this.move = move;
		
	}
	
	protected List createSelectionHandles() {
		List list = new ArrayList();
		GraphicalEditPart part = (GraphicalEditPart) getHost();
		if (this.move) {
			ResizableHandleKit.addMoveHandle(part, list);
		}
		for (int i = 0; i < 4; i++) {
			if ((style & directionList[i]) != 0) {
				ResizableHandleKit.addHandle(part, list, directionList[i]);
			}
		}	
		if (style == (HORIZONTAL | VERTICAL)) {
			ResizableHandleKit.addHandle(part, list, PositionConstants.SOUTH_EAST);
			ResizableHandleKit.addHandle(part, list, PositionConstants.SOUTH_WEST);
			ResizableHandleKit.addHandle(part, list, PositionConstants.NORTH_WEST);
			ResizableHandleKit.addHandle(part, list, PositionConstants.NORTH_EAST);
		}
		return list;
	}
	
	public static int getStyle(EditPart editPart) {
		int v = NONRESIZE;
		if (editPart instanceof HorizontalResizable) {
			v |= HORIZONTAL;
		}
		if (editPart instanceof VerticalResizable) {
			v |= VERTICAL;
		}
		return v;
	}
}
