/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.Messages;

import org.eclipse.gef.commands.Command;

public class ChangePositionCommand extends Command {
	private Component child;

	private int index;

	public ChangePositionCommand(Component child) {
		super(child.getName() + Messages.getString("layout.cmd.position.msg")); //$NON-NLS-1$
		this.child = child;
	}

	public void execute() {
		MaskatElement parent = child.getParent();
		index = parent.getChildIdx(child);
		int pos = parent.getTypedChildren(Component.class).size();
		parent.removeChild(child);
		parent.addChildToIdx(child, pos - 1);
	}

	public void undo() {
		MaskatElement parent = child.getParent();
		parent.removeChild(child);
		parent.addChildToIdx(child, index);
	}

	public boolean canUndo() {
		return true;
	}
}
