/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import jp.sf.maskat.ui.wizards.application.NewMaskatApplicationWizard;
import jp.sf.maskat.ui.wizards.layout.NewLayoutFileWizard;
import jp.sf.maskat.ui.wizards.project.NewMaskatProjectWizard;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;


public class MaskatPerspectiveFactory implements IPerspectiveFactory {

	public static final String ID_PALETTE = "org.eclipse.gef.ui.palette_view"; //$NON-NLS-1$

	public static final String ID_PROJECT_EXPLORER =
			"org.eclipse.ui.navigator.ProjectExplorer";	 //$NON-NLS-1$
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {
		defineActions(layout);
		defineLayout(layout);
	}

	private void defineActions(IPageLayout layout) {
		layout.addNewWizardShortcut(NewMaskatProjectWizard.WIZARD_ID);
		layout.addNewWizardShortcut(NewLayoutFileWizard.WIZARD_ID);
		layout.addNewWizardShortcut(NewMaskatApplicationWizard.WIZARD_ID);
		
		layout.addShowViewShortcut(ID_PROJECT_EXPLORER);
		layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
		layout.addShowViewShortcut(ID_PALETTE);
	}
	
	private void defineLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();

		IFolderLayout topLeft = layout.createFolder(
				"topLeft", IPageLayout.LEFT, (float) 0.20, editorArea); //$NON-NLS-1$

		topLeft.addView(ID_PROJECT_EXPLORER);
//		topLeft.addView(ID_PALETTE);
		
		topLeft.addPlaceholder(ID_PALETTE);

		IFolderLayout bottomLeft = layout.createFolder(
				"bottomLeft", IPageLayout.BOTTOM, (float) 0.50, //$NON-NLS-1$
				"topLeft");//$NON-NLS-1$
		bottomLeft.addView(IPageLayout.ID_OUTLINE);

		IFolderLayout bottomRight = layout.createFolder(
				"bottomRight", IPageLayout.BOTTOM, (float) 0.66, //$NON-NLS-1$
				editorArea);
		bottomRight.addView(IPageLayout.ID_PROP_SHEET); 
		bottomRight.addPlaceholder(IPageLayout.ID_TASK_LIST);
		bottomRight.addPlaceholder(IPageLayout.ID_BOOKMARKS);
	}
}
