/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;

import java.util.Map;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.layout.Desc;
import jp.sf.maskat.core.layout.JavaScript;


import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.strategy.ValueSuppressionStrategy;

public class LayoutValueSuppressionStrategy extends ValueSuppressionStrategy {
	
	private MaskatElement currentElement = null;
	
	public boolean suppressAttribute(AttributeDescriptor attributeDescriptor, String value) {
		if(attributeDescriptor.getPropertyName() != null && value != null) {
			return isDefaultValue(
					attributeDescriptor.getPropertyName(),
					attributeDescriptor.getPropertyType(),
					value);
		}
		return false;
	}
	
	private boolean isDefaultValue(String attribute, Class type, String value) {
		Map defaultMap = currentElement.getDefaultValues();
		if (defaultMap.containsKey(attribute)) {
			Object v = defaultMap.get(attribute);
			if (!(v instanceof String)) {
				v = String.valueOf(v);
			}
			return value.equals((String) v);
			
//		} else if (type != null && Number.class.isAssignableFrom(type) && "".equals(value)) {
//			return true;
		}
		return false;
	}

    public boolean suppressElement(ElementDescriptor element, String namespaceUri, String localName, String qualifiedName, Object value) {
    	if (value instanceof MaskatElement) {
    		currentElement = (MaskatElement)value;
    		if (value instanceof Component) {
    			return !((Component)value).hasEnabledEvents();
    		}
    		if (value instanceof Desc) {
    			return ((Desc)value).getComment() == null;
    		}
    	} else if (value instanceof JavaScript) {
			return ((JavaScript) value).getContent() == null;
		}
    	return ValueSuppressionStrategy.DEFAULT.suppressElement(element, namespaceUri, localName, qualifiedName, value);
    }
}
