/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.project.NewMaskatProjectCreationPage;
import jp.sf.maskat.ui.wizards.project.PluginResourceData;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMaskatProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String WIZARD_ID = "jp.sf.maskat.ui.newMaskatProjectWizard";
    private IWorkbench workbench;
    private NewMaskatProjectCreationPage mainPage;
    private IProject newProject;
    private IConfigurationElement configElement;

    public NewMaskatProjectWizard() {
        IDialogSettings workbenchSettings = MaskatUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewMaskatProjectWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewMaskatProjectWizard");
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("wizard.project.windowTitle"));
        this.setDefaultPageImageDescriptor(MaskatUIPlugin.getImageDescriptor("IMG_WIZBAN_NEWPROJECT"));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.configElement = config;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewMaskatProjectCreationPage((IPath)new Path("./maskat"), true);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        if (this.createNewProject() == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        BasicNewResourceWizard.selectAndReveal((IResource)this.newProject, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        return true;
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        final IPath fwPath = this.mainPage.getMaskatFrameworkPath();
        final boolean copy = this.mainPage.shouldCopyMaskatFramework();
        final PluginResourceData[] plugins = this.mainPage.getSelectedPlugins();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewMaskatProjectWizard.this.createProject(description, newProjectHandle, monitor, fwPath, copy, plugins);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, IPath frameWorkPath, boolean shouldCopy, PluginResourceData[] plugins) throws CoreException, OperationCanceledException {
        try {
            block23: {
                monitor.beginTask("", 4000);
                projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    MaskatNature.addNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    MaskatNature nature = MaskatNature.getNature(projectHandle);
                    nature.setMaskatFrameworkPath(frameWorkPath);
                    nature.getPreferenceStore().save();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "jp.sf.maskat.ui", 0, e.getMessage(), (Throwable)e));
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IPath destinationPath = projectHandle.getFullPath().append(frameWorkPath);
                ContainerGenerator generator = new ContainerGenerator(destinationPath);
                IContainer destination = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (shouldCopy) {
                    LinkedHashMap properties = new LinkedHashMap();
                    int i = 0;
                    while (i < plugins.length) {
                        File[] contents = new File(plugins[i].getUrl().getFile()).listFiles();
                        URI[] uris = new URI[contents.length];
                        int j = 0;
                        while (j < contents.length) {
                            uris[j] = contents[j].toURI();
                            ++j;
                        }
                        CopyFilesAndFoldersOperation op = new CopyFilesAndFoldersOperation(this.getShell());
                        op.copyFilesInCurrentThread(uris, destination, (IProgressMonitor)new SubProgressMonitor(monitor, 1000 / plugins.length));
                        if (plugins[i].getInitializer() != null) {
                            plugins[i].getInitializer().initialize(properties, true);
                        }
                        ++i;
                    }
                    if (!properties.isEmpty()) {
                        Object var13_16;
                        InputStream in = null;
                        try {
                            try {
                                IFile file = destination.getFile((IPath)new Path("properties.json"));
                                in = new ByteArrayInputStream(this.encodeJson(properties, 0).getBytes("UTF-8"));
                                if (file.exists()) {
                                    file.delete(true, monitor);
                                }
                                file.create(in, true, monitor);
                            }
                            catch (UnsupportedEncodingException e) {
                                this.throwCoreException(e.getMessage());
                            }
                            var13_16 = null;
                            if (in == null) break block23;
                        }
                        catch (Throwable throwable) {
                            var13_16 = null;
                            if (in == null) throw throwable;
                            try {
                                in.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {}
                        catch (IOException iOException) {}
                        in.close();
                    }
                }
            }
            Object var15_22 = null;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    private String encodeJson(Map map, int indent) {
        String separator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("{");
        sb.append(separator);
        String indentString = this.repeat("\t", indent + 1);
        Iterator ite = map.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry entry = ite.next();
            sb.append(indentString);
            sb.append("\"").append(entry.getKey()).append("\": ");
            Object value = entry.getValue();
            if (value instanceof String) {
                sb.append("\"").append(value).append("\"");
            } else if (value instanceof Map) {
                sb.append(this.encodeJson((Map)value, indent + 1));
            } else {
                sb.append(value);
            }
            if (ite.hasNext()) {
                sb.append(",");
            }
            sb.append(separator);
        }
        return sb.append(this.repeat("\t", indent)).append("}").toString();
    }

    private String repeat(String str, int repeat) {
        StringBuffer sb = new StringBuffer();
        if (str != null && repeat > 0) {
            int i = 0;
            while (i < repeat) {
                sb.append(str);
                ++i;
            }
        }
        return sb.toString();
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "jp.sf.maskat.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

