/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.commands.SetPropertyCommand;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class SetEventPropertyCommand
extends SetPropertyCommand {
    private Class classType;
    private TreeViewer treeViewer;
    private boolean refresh = true;

    public SetEventPropertyCommand(TreeViewer treeViewer, Class classType, Object bean, String propertyName, Object newValue) {
        this(treeViewer, classType, bean, propertyName, newValue, true);
    }

    public SetEventPropertyCommand(TreeViewer treeViewer, Class classType, Object bean, String propertyName, Object newValue, boolean refresh) {
        super(bean, propertyName, newValue);
        this.treeViewer = treeViewer;
        this.classType = classType;
        this.refresh = refresh;
    }

    public Class getClassType() {
        return this.classType;
    }

    public Object getBean() {
        return this.bean;
    }

    public void redo() {
        try {
            super.redo();
            if (this.refresh) {
                this.updateTree();
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public void undo() {
        try {
            super.undo();
            if (this.refresh) {
                this.updateTree();
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    private void updateTree() {
        ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.bean, this.classType);
        if (treeNode instanceof EventTreeNode) {
            this.treeViewer.refresh((Object)treeNode.getParent(), true);
            this.treeViewer.expandToLevel(2);
            treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.bean, this.classType);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)treeNode), true);
        } else if (treeNode != null) {
            this.treeViewer.update((Object)treeNode, null);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)treeNode), true);
        }
    }
}

