/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Bind;
import jp.sf.maskat.core.event.Header;
import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.HeaderTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.LocalDataBinding;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceBind;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceChildNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetBind;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetChildNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.Validation;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TreeNodeTransfer
extends ByteArrayTransfer {
    private static TreeNodeTransfer instance = new TreeNodeTransfer();
    private static final String TYPE_NAME = "jp.sf.maskat.treenode";
    private static final int TYPEID = TreeNodeTransfer.registerType((String)"jp.sf.maskat.treenode");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    public static TreeNodeTransfer getInstance() {
        return instance;
    }

    private TreeNodeTransfer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ITreeNode[] fromByteArray(byte[] bytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            ITreeNode[] nodes = new ITreeNode[n];
            int i = 0;
            while (true) {
                if (i >= n) {
                    return nodes;
                }
                ITreeNode node = this.readTreeNode(null, in);
                if (node == null) {
                    return null;
                }
                nodes[i] = node;
                ++i;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((ITreeNode[])object);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        try {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            return this.fromByteArray(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ITreeNode readTreeNode(ITreeNode parent, DataInputStream dataIn) throws IOException {
        MaskatElement model;
        String treeNodeClassName = dataIn.readUTF();
        ITreeNode child = this.getTreeNodeInstance(treeNodeClassName);
        if (child == null) {
            return null;
        }
        if (child instanceof HeaderTreeNode) {
            child = new HeaderTreeNode(null, dataIn.readBoolean());
        }
        if ((model = this.readModelInfo(dataIn)) == null) {
            return null;
        }
        child.setModel(model);
        if (parent != null) {
            parent.addChild(child);
            if ((parent instanceof SourceNode || parent instanceof TargetNode) && !(child instanceof SourceBind)) {
                child.setModel(parent.getModel());
            }
            if (child instanceof Header || child instanceof Bind) {
                parent.getModel().addChild((Object)child.getModel());
            }
        }
        int n = dataIn.readInt();
        int i = 0;
        while (i < n) {
            this.readTreeNode(child, dataIn);
            ++i;
        }
        return child;
    }

    protected byte[] toByteArray(ITreeNode[] treeNodes) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(treeNodes.length);
            int i = 0;
            while (i < treeNodes.length) {
                this.writeTreeNode(treeNodes[i], out);
                ++i;
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException iOException) {}
        return bytes;
    }

    private void writeTreeNode(ITreeNode node, DataOutputStream dataOut) throws IOException {
        dataOut.writeUTF(node.getClass().getName());
        if (node instanceof HeaderTreeNode) {
            dataOut.writeBoolean(((HeaderTreeNode)node).isGlobal());
        }
        this.writeModelInfo(node.getModel(), dataOut);
        Object[] children = node.getChildren();
        dataOut.writeInt(children.length);
        int i = 0;
        while (i < children.length) {
            this.writeTreeNode((ITreeNode)children[i], dataOut);
            ++i;
        }
    }

    private ITreeNode getTreeNodeInstance(String className) {
        try {
            Class<?> treeNodeClass = Class.forName(className);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.HeaderTreeNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz)) {
                return new HeaderTreeNode(null, false);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceBind");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz2)) {
                return new SourceBind(null);
            }
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetBind");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz3)) {
                return new TargetBind(null);
            }
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz4)) {
                return new SourceNode(null);
            }
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.Validation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz5)) {
                return new Validation(null);
            }
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceChildNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz6)) {
                return new SourceChildNode(null);
            }
            Class<?> clazz7 = class$6;
            if (clazz7 == null) {
                try {
                    clazz7 = class$6 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz7)) {
                return new TargetNode(null);
            }
            Class<?> clazz8 = class$7;
            if (clazz8 == null) {
                try {
                    clazz8 = class$7 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.TargetChildNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz8)) {
                return new TargetChildNode(null);
            }
            Class<?> clazz9 = class$8;
            if (clazz9 == null) {
                try {
                    clazz9 = class$8 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.LocalDataBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (treeNodeClass.equals(clazz9)) {
                return new LocalDataBinding(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private MaskatElement readModelInfo(DataInputStream dataIn) throws IOException {
        String modelClassName = dataIn.readUTF();
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("jp.sf.maskat.core.event.Bind");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (modelClassName.equals(clazz.getName())) {
            Bind bind = new Bind();
            bind.setNode(dataIn.readUTF());
            bind.setFromkey(dataIn.readUTF());
            bind.setTokey(dataIn.readUTF());
            return bind;
        }
        Class<?> clazz2 = class$10;
        if (clazz2 == null) {
            try {
                clazz2 = class$10 = Class.forName("jp.sf.maskat.core.event.Header");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (modelClassName.equals(clazz2.getName())) {
            Header header = new Header();
            header.setName(dataIn.readUTF());
            header.setValue(dataIn.readUTF());
            return header;
        }
        Class<?> clazz3 = class$11;
        if (clazz3 == null) {
            try {
                clazz3 = class$11 = Class.forName("jp.sf.maskat.core.event.Source");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (modelClassName.equals(clazz3.getName())) {
            Source source = new Source();
            source.setFromkey(dataIn.readUTF());
            source.setMax(dataIn.readInt());
            source.setMin(dataIn.readInt());
            String childNode = dataIn.readUTF();
            childNode = "".equals(childNode) ? null : childNode;
            source.setChildNode(childNode);
            source.setDesc(dataIn.readUTF());
            source.setIdxRef(dataIn.readUTF());
            source.setNode(dataIn.readUTF());
            source.setObj(dataIn.readUTF());
            source.setRegexp(dataIn.readUTF());
            source.setTeleType(dataIn.readUTF());
            source.setType(dataIn.readUTF());
            source.setSendBlankElement(dataIn.readBoolean());
            return source;
        }
        Class<?> clazz4 = class$12;
        if (clazz4 == null) {
            try {
                clazz4 = class$12 = Class.forName("jp.sf.maskat.core.event.Target");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (modelClassName.equals(clazz4.getName())) {
            Target target = new Target();
            target.setIn(dataIn.readUTF());
            String inkey = dataIn.readUTF();
            inkey = "".equals(inkey) ? null : inkey;
            target.setInkey(inkey);
            target.setOut(dataIn.readUTF());
            String teleType = dataIn.readUTF();
            target.setTeleType("".equals(teleType) ? null : teleType);
            target.setType(dataIn.readUTF());
            String workType = dataIn.readUTF();
            target.setWorkType("".equals(workType) ? null : workType);
            return target;
        }
        return null;
    }

    private void writeModelInfo(MaskatElement bean, DataOutputStream dataOut) throws IOException {
        dataOut.writeUTF(bean.getClass().getName());
        if (bean instanceof Bind) {
            Bind bind = (Bind)bean;
            dataOut.writeUTF(this.nullString(bind.getNode()));
            dataOut.writeUTF(this.nullString(bind.getFromkey()));
            dataOut.writeUTF(this.nullString(bind.getTokey()));
            return;
        }
        if (bean instanceof Header) {
            Header header = (Header)bean;
            dataOut.writeUTF(this.nullString(header.getName()));
            dataOut.writeUTF(this.nullString(header.getValue()));
        }
        if (bean instanceof Source) {
            Source source = (Source)bean;
            dataOut.writeUTF(source.getFromkey());
            dataOut.writeInt(source.getMax());
            dataOut.writeInt(source.getMin());
            dataOut.writeUTF(this.nullString(source.getChildNode()));
            dataOut.writeUTF(this.nullString(source.getDesc()));
            dataOut.writeUTF(this.nullString(source.getIdxRef()));
            dataOut.writeUTF(this.nullString(source.getNode()));
            dataOut.writeUTF(this.nullString(source.getObj()));
            dataOut.writeUTF(this.nullString(source.getRegexp()));
            dataOut.writeUTF(this.nullString(source.getTeleType()));
            dataOut.writeUTF(this.nullString(source.getType()));
            dataOut.writeBoolean(source.isSendBlankElement());
            return;
        }
        if (bean instanceof Target) {
            Target target = (Target)bean;
            dataOut.writeUTF(this.nullString(target.getIn()));
            dataOut.writeUTF(this.nullString(target.getInkey()));
            dataOut.writeUTF(this.nullString(target.getOut()));
            dataOut.writeUTF(this.nullString(target.getTeleType()));
            dataOut.writeUTF(this.nullString(target.getType()));
            dataOut.writeUTF(this.nullString(target.getWorkType()));
            return;
        }
    }

    private String nullString(String in) {
        return in == null ? "" : in;
    }
}

