/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.commands;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutDef;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import org.eclipse.gef.commands.Command;

public class AddBasicDefCommand
extends Command {
    private MaskatElement parent;
    private MaskatElement child;
    private MaskatElement originalParent;
    private int originalIdx;
    private boolean addedPrefixMapping;

    public AddBasicDefCommand(MaskatElement parent, MaskatElement child) {
        super(Messages.getString("layout.cmd.add.msg.title"));
        this.parent = parent;
        this.child = child;
        this.addedPrefixMapping = false;
    }

    public void execute() {
        this.originalParent = this.child.getParent();
        if (this.originalParent != null) {
            this.originalIdx = this.originalParent.getChildIdx((Object)this.child);
            if (this.originalIdx == -1) {
                this.originalParent = null;
            } else {
                this.originalParent.removeChild((Object)this.child);
            }
        } else {
            Layout layout = ((Component)this.parent).getLayout();
            ComponentUtils.setUniqueName(layout, (Component)this.child);
        }
        this.parent.addChild((Object)this.child);
        if (this.child instanceof DynaComponent) {
            LayoutDef layoutDef = ((DynaComponent)this.child).getLayout().getLayoutDef();
            DynaComponent dynaComponent = (DynaComponent)this.child;
            DynaComponentClass dynaClass = (DynaComponentClass)dynaComponent.getDynaClass();
            ComponentLibrary library = dynaClass.getLibrary();
            String namespace = library.getNamespaceURI();
            String prefix = library.getPrefix();
            if (namespace == null || "".equals(namespace)) {
                this.addedPrefixMapping = false;
            } else if (!layoutDef.getNamespaces().containsKey(namespace)) {
                layoutDef.getNamespaces().put(namespace, prefix);
                this.addedPrefixMapping = true;
            }
        }
    }

    public void undo() {
        this.parent.removeChild((Object)this.child);
        if (this.originalParent != null) {
            this.originalParent.addChildToIdx((Object)this.child, this.originalIdx);
        }
        if (this.child instanceof DynaComponent && this.addedPrefixMapping) {
            DynaComponent dynaBean = (DynaComponent)this.child;
            DynaComponentClass dynaClass = (DynaComponentClass)dynaBean.getDynaClass();
            String namespaceURI = dynaClass.getLibrary().getNamespaceURI();
            LayoutDef layoutDef = dynaBean.getLayout().getLayoutDef();
            layoutDef.getNamespaces().remove(namespaceURI);
        }
    }

    public boolean canUndo() {
        return true;
    }
}

