/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.ui.EventEditorContributor;
import jp.sf.maskat.ui.MaskatUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MaskatNature
implements IProjectNature {
    public static final String NATURE_ID = "jp.sf.maskat.ui.maskatNature";
    public static final String FRAMEWORK_PATH = "frameworkPath";
    public static final String FRAMEWORK_PATH_DEFAULT = "./maskat";
    public static final String GRID_SELECTION = "gridSelection";
    public static final String GRID_SELECTION_DEFAULT = "false";
    public static final String SNAPTOGRID_SELECTION = "snapToGridSelection";
    public static final String SNAPTOGRID_SELECTION_DEFAULT = "false";
    public static final String SNAPTOGEOMETRY_SELECTION = "snapToGeometrySelection";
    public static final String SNAPTOGEOMETRY_SELECTION_DEFAULT = "false";
    public static final String GRID_SIZE = "gridSize";
    public static final String GRID_SIZE_DEFAULT = "15";
    private IProject project;
    private IPersistentPreferenceStore store;
    private EventEditorContributor contributor = null;

    public static void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled() || project == null) {
            return;
        }
        if (!project.hasNature(NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] oldIds = description.getNatureIds();
            String[] newIds = new String[oldIds.length + 1];
            System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
            newIds[oldIds.length] = NATURE_ID;
            description.setNatureIds(newIds);
            project.setDescription(description, monitor);
            project.refreshLocal(2, monitor);
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources.natures");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String natureId = extension.getUniqueIdentifier();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("runtime".equals(element.getName())) {
                    IConfigurationElement[] children = element.getChildren();
                    int k = 0;
                    while (k < children.length) {
                        Object object;
                        if ("run".equals(children[k].getName()) && (object = children[k].createExecutableExtension("class")) instanceof EventEditorContributor) {
                            if (project.hasNature(natureId)) break;
                            IProjectDescription description = project.getDescription();
                            String[] oldIds = description.getNatureIds();
                            String[] newIds = new String[oldIds.length + 1];
                            System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
                            newIds[oldIds.length] = natureId;
                            description.setNatureIds(newIds);
                            project.setDescription(description, monitor);
                            break;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void removeNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled() || project == null) {
            return;
        }
        if (project.hasNature(NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] oldIds = description.getNatureIds();
            String[] newIds = new String[oldIds.length - 1];
            int i = 0;
            while (i < oldIds.length) {
                if (oldIds[i].equals(NATURE_ID)) {
                    System.arraycopy(oldIds, 0, newIds, 0, i);
                    System.arraycopy(oldIds, i + 1, newIds, i, newIds.length - i);
                    break;
                }
                ++i;
            }
            description.setNatureIds(newIds);
            project.setDescription(description, monitor);
            project.refreshLocal(2, monitor);
        }
    }

    public static MaskatNature getNature(IProject project) {
        try {
            if (project != null && project.hasNature(NATURE_ID)) {
                return (MaskatNature)project.getNature(NATURE_ID);
            }
        }
        catch (CoreException e) {
            MaskatUIPlugin.log(e.getStatus());
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        if (project == null) {
            return;
        }
        this.project = project;
        ProjectScope scope = new ProjectScope(project);
        this.store = new ScopedPreferenceStore((IScopeContext)scope, "jp.sf.maskat.ui");
        this.store.setDefault(FRAMEWORK_PATH, FRAMEWORK_PATH_DEFAULT);
        this.store.setDefault(GRID_SELECTION, "false");
        this.store.setDefault(SNAPTOGRID_SELECTION, "false");
        this.store.setDefault(SNAPTOGEOMETRY_SELECTION, "false");
        this.store.setDefault(GRID_SIZE, GRID_SIZE_DEFAULT);
        this.contributor = null;
        try {
            IProjectDescription description = this.project.getDescription();
            String[] natureIds = description.getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                IProjectNature nature;
                if (!NATURE_ID.equals(natureIds[i]) && (nature = this.project.getNature(natureIds[i])) instanceof EventEditorContributor) {
                    this.contributor = (EventEditorContributor)nature;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MaskatUIPlugin.log(e.getStatus());
        }
    }

    public IPersistentPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IPath getMaskatFrameworkPath() {
        return new Path(this.store.getString(FRAMEWORK_PATH));
    }

    public void setMaskatFrameworkPath(IPath path) {
        this.store.setValue(FRAMEWORK_PATH, path.toString());
    }

    public boolean getGridSelection() {
        return new Boolean(this.store.getString(GRID_SELECTION));
    }

    public void setGridSelection(boolean selection) {
        this.store.setValue(GRID_SELECTION, String.valueOf(selection));
    }

    public boolean getSnapToGridSelection() {
        return new Boolean(this.store.getString(SNAPTOGRID_SELECTION));
    }

    public void setSnapToGridSelection(boolean selection) {
        this.store.setValue(SNAPTOGRID_SELECTION, String.valueOf(selection));
    }

    public boolean getSnapToGeometrySelection() {
        return new Boolean(this.store.getString(SNAPTOGEOMETRY_SELECTION));
    }

    public void setSnapToGeometrySelection(boolean selection) {
        this.store.setValue(SNAPTOGEOMETRY_SELECTION, String.valueOf(selection));
    }

    public int getGridSize() {
        String v = this.store.getString(GRID_SIZE);
        if (v == null || v.length() < 1) {
            v = GRID_SIZE_DEFAULT;
        }
        return new Integer(v);
    }

    public void setGridSize(int size) {
        this.store.setValue(GRID_SIZE, String.valueOf(size));
    }

    public void setEventEditorContributor(EventEditorContributor contributor) {
        this.contributor = contributor;
    }

    public EventEditorContributor getEventEditorContributor() {
        return this.contributor;
    }

    public void openEventHandlerImpl(Event event) throws CoreException {
        if (this.contributor != null) {
            this.contributor.openEventHandlerImpl(event);
        }
    }
}

