#
# Copyright (c)  2006-2008 Maskat Project.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
class GourmetController < ApplicationController
  
  def search_restaurant
    request = params[:request]
    conditions = []
    
    if request[:budgetLowerLimit].to_i > 0
      conditions << "budget >= :budgetLowerLimit"
    end
    if request[:budgetUpperLimit].to_i > 0
      conditions << "budget <= :budgetUpperLimit"
    end
    
    request[:styles] = []
    request[:styles] << 0 if request[:western] == "true"
    request[:styles] << 1 if request[:japanese] == "true"
    request[:styles] << 2 if request[:chinese] == "true"
    unless request[:styles].empty?
      conditions << "style IN (:styles)"
    end
    
    conditions << "coupon = 1" if request[:coupon] == "true"
    conditions = conditions.empty? ? nil : [conditions.join(" AND "), request]
    
    @restaurants = GourmetRestaurant.find(:all, :conditions => conditions)
  end
end
