#
# Copyright (c)  2006-2008 Maskat Project.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
class FruitshopController < ApplicationController
  @@customer_id_seq = 0
  @@order_id_seq = 0

  def codelib
    if params.key? :customerIdText
      pattern = params[:customerIdText]
      model, code, label = FruitshopCustomer, "id", "name"
    elsif params.key? :productIdText
      pattern = params[:productIdText]
      model, code, label = FruitshopProduct, "id", "name"
    end
    
    if pattern
      conditions = ["#{code} LIKE :pattern OR #{label} LIKE :pattern",
      {:pattern => "%#{pattern}%"}]
    end
    
    @codes = model.find(:all,
      :select => "#{code} as code, #{label} as label",
      :conditions => conditions)
    
    headers["Content-Type"] = "text/json; charset=UTF-8"
    render :text => @codes.map{|item| [item.code, item.label]}.to_json
  end

  def register_customer
    if @@customer_id_seq == 0
      @@customer_id_seq = FruitshopCustomer.find(
        :first,
        :select => "id",
        :order => "id DESC").id.to_i
    end
    @@customer_id_seq += 1

    @customer = FruitshopCustomer.new(
      :name => params[:request][:name],
      :zip => params[:request][:zip],
      :address => params[:request][:address],
      :phone => params[:request][:phone],
      :fax => params[:request][:fax],
      :contact_person => params[:request][:contactPerson])
    @customer.id = sprintf("%04d", @@customer_id_seq)
    @customer.save
  end
  
  def search_customer
    @customer = FruitshopCustomer.find(params[:request][:customerId])
  end
  
  def search_product
    @product = FruitshopProduct.find(params[:request][:productId])
  end
  
  def list_orders
    @orders = FruitshopOrder.find(:all)
  end
  
  def register_order
    today = Time.now

    if @@order_id_seq == 0
      @@order_id_seq = FruitshopOrder.find(
        :all,
        :select => "id",
        :conditions => ["id LIKE ?", today.strftime("%Y%m%d") + "%"]).size
    end
    @@order_id_seq += 1

    order = FruitshopOrder.new(
      :customer_id => params[:request][:customerId],
      :order_date => today,
      :total => 0)
    order.id = today.strftime("%Y%m%d") + sprintf("-%03d", @@order_id_seq)

    details = params[:request][:order][:detail]
    details = [details] unless details.is_a? Array
    for hash in details
      detail = FruitshopOrderDetail.create(
        :order_id => order.id,
        :product_id => hash["productId"],
        :quantity => hash["quantity"])
      order.total += detail.fruitshop_product.unit_price * detail.quantity
    end

    order.save
  end
end
