/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.log.SimpleLog").extend("maskat.log.Log", {

	initialize: function(name, level, focus) {
		this.base.apply(this, arguments);
		this.name = name;
		this.level = level || maskat.log.Log.WARN;
		this.focus = focus;
	},

	trace: function(message, error) {
		if (this.level <= maskat.log.Log.TRACE) {
			this.log(this.format("TRACE", message), "#666666");
		}
	},

	debug: function(message, error) {
		if (this.level <= maskat.log.Log.DEBUG) {
			this.log(this.format("DEBUG", message), "green");
		}
	},

	info: function(message, error) {
		if (this.level <= maskat.log.Log.INFO) {
			this.log(this.format("INFO", message), "#000099");
		}
	},

	warn: function(message, error) {
		if (this.level <= maskat.log.Log.WARN) {
			this.log(this.format("WARN", message), "#999900");
		}
	},

	error: function(message, error) {
		if (this.level <= maskat.log.Log.ERROR) {
			this.log(this.format("ERROR", message), "red");
		}
	},

	fatal: function(message, error) {
		if (this.level <= maskat.log.Log.FATAL) {
			this.log(this.format("FATAL", message), "#660066");
		}
	},
	
	console: null,
	
	format: function(level, message) {
		return (new Date()).toLocaleString()  + " [" + this.name + "] " + level + " -  " + message;
	},
	
	log: function(message, color) {
		var doc = this.getLogDocument();
		var div = this.getLogElement(doc);
		var level = doc.createElement("pre");
		level.style.color = color ? color : "black";
		level.appendChild(doc.createTextNode(message));
		div.appendChild(level);
		div.appendChild(doc.createElement("br"));
		div.scrollTop = div.scrollHeight - div.offsetHeight;
		if (this.focus == true) {
			this.console.focus();
		}
	},	
	
	getLogDocument: function() {
		if (!this.console || this.console.closed) {
			var prop = "width=500,height=100,status=no,resizable,dependent=yes";
			this.console = window.open("", "maskatSimpleLog", prop);
		}
		return this.console.document;
	},
	
	getLogElement: function(doc) {
		var element = doc.getElementById("maskat.log.SimpleLog");
		if (!element) {
			element = doc.createElement("div");
			element.setAttribute("id", "maskat.log.SimpleLog");
			element.style.position = "absolute";
			element.style.width = "98%";
			element.style.height = "96%";
			element.style.top = "4";
			element.innerHTML = "<div style=\"height:96%;overflow:auto\"></div>";
			doc.getElementsByTagName("body").item(0).appendChild(element);
		}
		return element.getElementsByTagName("div").item(0);
	}
});
