/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.core.Plugin", {

	_static: {
		/** プラグインの動作状態を表す定数 */
		INIT: 1,
		INSTALL: 2,
		LOADING: 3,
		READY: 4,
		RUNNING: 5,

		/** プラグインのクラスを登録するレジストリ */
		registry: {},		

		/**
		 * レジストリにプラグインの実装クラスを登録します。
		 *
		 * プラグインの実装クラスは maskat.core.Plugin クラスを継承し、引数
		 * なしのコンストラクタを持っている必要があります。
		 * 
		 * @param clazz プラグインの実装クラス
		 */
		register: function(clazz) {
			var pluginId = clazz.prototype.getPluginId();
			this.registry[pluginId] = clazz;
		}
	},

	/**
	 * コンストラクタ
	 */
	initialize: function() {
		this.status = maskat.core.Plugin.INIT;
		this.properties = new maskat.util.Properties();
	},

	/**
	 * プラグインの実行状態を返します。
	 *
	 * @return プラグインの実行状態
	 */
	getStatus: function(status) {
		return this.status;
	},

	/**
	 * プラグインの実行状態を設定します。
	 *
	 * @param status プラグインの実行状態
	 */
	setStatus: function(status) {
		this.status = status;
	},

	/**
	 * プラグインのプロパティ値を取得します。
	 *
	 * @return 指定したキーに対応するプロパティ値 
	 */
	getProperty: function(key) {
		return this.properties.getProperty(key);
	}, 

	/**
	 * プラグインのプロパティを設定します。
	 *
	 * @param key プロパティキー
	 * @param value プロパティの値
	 */
	setProperty: function(key, value) {
		this.properties.setProperty(key, value);
	}, 

	/**
	 * プラグインのプロパティをプロパティキーと値が対になったオブジェクトで
	 * まとめて設定します。
	 *
	 * @param values プロパティキーと値が対になったオブジェクト 
	 */
	setProperties: function(values) {
		this.properties.setProperties(values);
	}, 

	/**
	 * プラグイン識別子を返します。
	 * 
	 * @return プラグイン識別子
	 */
	getPluginId: function() {
		return null;
	},

	/**
	 * プラグインのバージョン識別子を返します。
	 * 
	 * @return プラグインのバージョン識別子
	 */
	getVersion: function() {
		return null;
	},

	/**
	 * このプラグインが別のプラグインに依存している場合、依存している
	 * プラグインの識別子を配列で返します。
	 *
	 * @return プラグイン識別子を要素とする配列、依存関係がなければ null
	 */
	getDependencies: function() {
		return null;
	},

	/**
	 * プラグインのロードが完了したかどうかを返します。
	 * 
	 * このメソッドが true を返すまでマスカットアプリケーションの実行は
	 * 開始しません。
	 * 
	 * @return ロードが完了していれば true、それ以外の場合は false
	 */
	isLoaded: function() {
		return true;
	},

	/**
	 * プラグインに必要なリソースをロードします。
	 * 
	 * @param app このプラグインを使用するマスカットアプリケーション
	 */
	load: function() {
		/* NOP */
	},

	/**
	 * プラグインの実行を開始します。
	 */
	start: function() {
		/* NOP */
	}

});
