package org.maskat.demo.chatclient;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MyChatClientServlet extends HttpServlet
{
	private static final long serialVersionUID = 6169907056984915450L;
	
	
	final 	String LOGIN = "btnLogin" ;
	final 	String LOGOUT = "btnExitChat" ;
	final 	String CLIENT_EX_MSG = "btnMsgSend" ;
	final 	String CLIENT_RCV_MSG = "sendMessages" ;
	
	static 	MyChatClientData	 dataObj				= new MyChatClientData();
	
	static 	UserManagementLogic  userManagementLogic	= new UserManagementLogic();
	static 	MessageExchangeLogic msgExLogic 			= new MessageExchangeLogic();
	
	
	public void doPost(HttpServletRequest request, HttpServletResponse response) 
		throws IOException
	{
		String 		requestType,
					result = null;

		response.setContentType("text/xml;charset=UTF-8");
		PrintWriter out = response.getWriter();
				 
		requestType = getRequestType(request);
		
		System.out.println("REQUEST TYPE: " + requestType);
		
		if (requestType.equals(LOGIN))
		{
			result = loginUser(request);
		}
		else if (requestType.equals(CLIENT_EX_MSG))
		{
			result = exchangeMessages(request);
		}
		else if (requestType.equals(CLIENT_RCV_MSG))
		{
			result = sendMessagesToClient(request);
		}
		else if (requestType.equals(LOGOUT))
		{
			logoutUser(request);
		}

		
		System.out.println("#####XML TO BE SEND TO CLIENT#####\n" + result);
		
		if (result != null)
		{
			out.write(result);
		}
		else
		{
			System.err.println("LOGGEDOUT");
			out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><result/>");
		}
	}

	
	

	private String sendMessagesToClient(HttpServletRequest request)
	{
		String  result,
		msgsToSendToClient,
				oldUsers,
				
				user = request.getHeader("maskat_user");
		
		msgsToSendToClient = msgExLogic.getMsgsFromQueue(user);
		
		oldUsers = userManagementLogic.getUsersAsXML();
		
		
		if (msgsToSendToClient != null && msgsToSendToClient != "")
		{
			result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
						"<srvsndmsg>\n\t" +
							"<result>\n\t\t" +
							msgsToSendToClient +
								oldUsers +
							"</result>\n" +
						"</srvsndmsg>";
		}
		else
		{
			result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
						"<srvsndmsg>\n\t" +
							"<result>\n\t\t" +
								oldUsers +
							"</result>\n" +
						"</srvsndmsg>";
		}
		
		return result;
	}



	private String exchangeMessages(HttpServletRequest request)
	{
		String  result,
				msgsToSend,
				oldUsers;
		
		String[] newMsgRcvd;
		
		
		if ( msgExLogic.getMsgExDataObject() == null )
		{
			msgExLogic.setMsgExDataObject(dataObj);
		}
		
		System.out.println("#########MessageExchange#########");
		
		
		newMsgRcvd = getNewMsgFromRequest(request);
		
		
		if (newMsgRcvd[1] != null)
		{
			msgExLogic.addNewMsgToQueue(newMsgRcvd);
		}
			
		msgsToSend = msgExLogic.getMsgsFromQueue(newMsgRcvd[0]);
		
		oldUsers = userManagementLogic.getUsersAsXML();
		
		
		if (msgsToSend != null && msgsToSend != "")
		{
			result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
						"<srvsndmsg>\n\t" +
							"<result>\n\t\t" +
								msgsToSend +
								oldUsers +
							"</result>\n" +
						"</srvsndmsg>";
		}
		else
		{
			result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
						"<srvsndmsg>\n\t" +
							"<result>\n\t\t" +
								oldUsers +
							"</result>\n" +
						"</srvsndmsg>";
		}
		
		msgsToSend = null;
		
		return result;
	}



	private String[] getNewMsgFromRequest(HttpServletRequest request)
	{

		Element 	root,
					elementNewMsg,
					elementSender;
		
		NodeList 	listNewMsg,
				 	listSender;
		
		String[]	 newMsg = new String[2];
	
		
		root 			= getRequestDataRootElement(request);
		
		
		listSender  	= root.getElementsByTagName("sender");
		listNewMsg 		= root.getElementsByTagName("msgsend");

		
		elementSender	= (Element)listSender.item(0);
		newMsg[0]		= elementSender.getFirstChild().getNodeValue();
		
		elementNewMsg	= (Element)listNewMsg.item(0);
		try
		{
			System.out.println("NEW MESSAGE CONTENT: " + elementNewMsg.getFirstChild().getNodeValue());
			newMsg[1]	= elementNewMsg.getFirstChild().getNodeValue();
		}
		catch (NullPointerException e)
		{
			newMsg[1] = null;
		}
					
		return newMsg;
	}


	
	private void logoutUser(HttpServletRequest request)
	{
		String[] userToLogout;

		if (userManagementLogic.getLoginDataObject() == null)
		{
			userManagementLogic.setLoginDataObject(dataObj);
		}
		
		
		System.out.println("#########MyChatClientLogout#########");
		
		userToLogout = getLogOutData(request);
				
		userManagementLogic.logUserOut(userToLogout);
		// String userLoggedOut = userManagementLogic.logUserOut(userToLogout);
		
//		if (userToLogout[0].equals(userLoggedOut));
//		{
//			System.out.println("User: " + userLoggedOut);
////			msgExLogic.cleanSentMsgs();
//		}
		
		System.out.println("User: " + userToLogout[0] + " COULD BE LOGGED OUT");		
	}
	

	private String loginUser(HttpServletRequest request)
	{
		String		result,
					oldUsers;
		String[] 	newUser;
		
		if (userManagementLogic.getLoginDataObject() == null)
		{
			userManagementLogic.setLoginDataObject(dataObj);
		}
		
		
		System.out.println("#########MyChatClientLogin#########");
		
		
		newUser = getLoginData(request);
		
		if (newUser != null)
		{
			// if user data is not used yet
			if(userManagementLogic.logUserIn(newUser))
			{
				oldUsers = userManagementLogic.getUsersAsXML();
				result 	= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
				"<loginresponse>\n\t" +
					"<result>\n\t\t" +
						"<success>\n\t\t\t" +
							"<value>" + "1" + "</value>\n\t\t\t" +
							"<loginmessage>\n\t\t\t\t" +
								"Login successful!\n\t\t\t\tLoading chat room...\n\t\t\t" +
							"</loginmessage>\n\t\t" +
						"</success>\n\t\t" +
						oldUsers +
					"</result>\n" +
				"</loginresponse>";
			}
			else  // user data is already used 
			{
				result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
				"<loginresponse>\n\t" +
					"<result>\n\t\t" +
						"<success>\n\t\t\t" +
							"<value>" + "0" + "</value>\n\t\t\t" +
							"<loginmessage>" +
								"The name or nickname is already in use. " +
								"Please choose another one..." +
							"</loginmessage>\n\t\t" +
						"</success>\n\t" +
					"</result>\n" +
				"</loginresponse>";
			}
		}
		else
		{
			result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
			"<loginresponse>\n\t" +
				"<result>\n\t\t" +
					"<success>\n\t\t\t" +
						"<value>" + "0" + "</value>\n\t\t\t" +
						"<loginmessage>" +
							"You must give a name and a nickname!" +
						"</loginmessage>\n\t\t" +
					"</success>\n\t" +
				"</result>\n" +
			"</loginresponse>";
		}
		
		return result;
	}



	private String getRequestType(HttpServletRequest request)
	{
		String strRequest = request.getHeader("maskat_componentid");
		if (strRequest == null)
		{
			strRequest = request.getHeader("maskat_requesttype");
		}
		return strRequest;
	}


	public Element getRequestDataRootElement(HttpServletRequest request)
	{
		Document 				doc;
			
		Element 				root = null;

		DocumentBuilderFactory 	dbfactory = DocumentBuilderFactory.newInstance();

    	DocumentBuilder 		builder;
    	
		try 
		{
			builder 	= dbfactory.newDocumentBuilder();
			
			doc 		= builder.parse(request.getInputStream());
			
			root 		= doc.getDocumentElement();
			
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return root;
	}
	
	

	private String[] getLogOutData(HttpServletRequest request)
	{
		Element 	root,
					elementUserName,
					elementUserNick;
		
		NodeList	listUserName,
	 				nodeListUserNick;

		String[]	userToLogout = {"",""};
		
		
		root = getRequestDataRootElement(request);
		
		
		listUserName 		= root.getElementsByTagName("username");
		elementUserName 	= (Element)listUserName.item(0);
		
		nodeListUserNick	= root.getElementsByTagName("usernickname");
		elementUserNick 	= (Element)nodeListUserNick.item(0);
		
		
		userToLogout[0] = elementUserName.getFirstChild().getNodeValue();
		userToLogout[1] = elementUserNick.getFirstChild().getNodeValue();
		
		return userToLogout;
	}

	
	
	public String[] getLoginData(HttpServletRequest request)
	{
		Element 	root,
					elementUserName,
					elementUserNick;
		NodeList	listUserName,
				 	nodeListUserNick;
		
		String[]	newUser = {"",""};

		
		root = getRequestDataRootElement(request);
		
		
		listUserName 		= root.getElementsByTagName("username");
		elementUserName 	= (Element)listUserName.item(0);
		
		nodeListUserNick	= root.getElementsByTagName("usernick");
		elementUserNick 	= (Element)nodeListUserNick.item(0);
		
		
		try
		{
			newUser[0] = elementUserName.getFirstChild().getNodeValue();
			newUser[1] = elementUserNick.getFirstChild().getNodeValue();
		}
		catch (NullPointerException e)
		{
			return null;
		}
		
		return newUser;
		
	}
}
















