/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.screendef.TreeNodeDef;
import org.maskat.framework.screendef.TreeViewDef;
import org.maskat.ide.gef.commands.AddBasicDefCommand;

public class TreeViewEditPolicy extends MyXYLayoutEditPolicy {

	protected Command createAddCommand(EditPart child, Object constraint) {
		Object childModel = child.getModel();
		if (!(childModel instanceof TreeNodeDef))
			return null;

		IBasicDef host = (IBasicDef) getHost().getModel();
		TreeNodeDef rootNode = (TreeNodeDef) ((TreeViewDef) host).getChildByTypeIdx(
				TreeNodeDef.class, 0);

		if (rootNode != null)
			// [gm[ĥꍇA[gm[hɒǉ
			return new AddBasicDefCommand(rootNode, (TreeNodeDef) childModel);

		return new AddBasicDefCommand(host, (TreeNodeDef) childModel);
	}

	protected Command getCreateCommand(CreateRequest request) {
		IBasicDef host = (IBasicDef) getHost().getModel();
		Object newObj = request.getNewObject();

		if (!(newObj instanceof TreeNodeDef)) {
			return null;
		}
		TreeNodeDef rootNode = (TreeNodeDef) ((TreeViewDef) host).getChildByTypeIdx(
				TreeNodeDef.class, 0);
		((TreeViewDef) host).getLayoutDef().setAppropriateNameForComponent(
				(TreeNodeDef) newObj);
		if (rootNode != null)
			// [gm[ĥꍇA[gm[hɒǉ
			return new AddBasicDefCommand(rootNode, (TreeNodeDef) newObj);

		return new AddBasicDefCommand(host, (TreeNodeDef) newObj);
	}

	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		return null;
	}
}
