/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.MyXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.TabPageFigure;

public class FolderPageEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {

	TabPageFigure tabPageFigure;

	public void activate() {
		super.activate();
		IComponentDef model = (IComponentDef) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		IComponentDef model = (IComponentDef) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected IFigure createFigure() {
		TabItemDef tabItem = (TabItemDef) getModel();
		tabPageFigure = new TabPageFigure(tabItem.getName());
		XYLayout layout = new XYLayout();
		tabPageFigure.setLayoutManager(layout);
		tabPageFigure
				.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		tabPageFigure.setVisible(false);
		return tabPageFigure;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new MyXYLayoutEditPolicy());
	}

	protected List getModelChildren() {
		if (getModel() instanceof IContainerDef) {
			return ((IContainerDef) getModel()).getComponentChildren();
		}
		return super.getModelChildren();
	}

	protected void refreshVisuals() {
		TabItemDef tabItem = (TabItemDef) getModel();
		TabFolderDef tabFolderDef = (TabFolderDef) tabItem.getParent();
		// Rectangle parentClientArea = ((AbstractGraphicalEditPart) this
		// .getParent()).getFigure().getClientArea();
		// QUESTION why clientArea returns (1,1,-2,-2)?

		Rectangle constraint = new Rectangle(0, 15, tabFolderDef.getWidth() - 1,
				tabFolderDef.getHeight() - 16);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
		}
		refreshVisuals();
	}

}