/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.tabbedproperties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.maskat.ide.editors.MaskatEditor;

public class MaskatTabbedPropertySheetPage extends TabbedPropertySheetPage {

	public MaskatTabbedPropertySheetPage(
			ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
		super(tabbedPropertySheetPageContributor);
	}

	private MaskatEditor editor = null;

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (editor != null) {
			if (editor.editMode == MaskatEditor.SOURCE_EDIT_MODE
					|| editor.editMode == MaskatEditor.TARGET_EDIT_MODE) {
				return;
			}
		} else {
			if (part instanceof MaskatEditor) {
				editor = (MaskatEditor) part;
			}
		}
		super.selectionChanged(part, selection);
	}
}
