/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.maskat.framework.IBasicDef;
import org.maskat.framework.screendef.ButtonDef;
import org.maskat.framework.screendef.CheckboxDef;
import org.maskat.framework.screendef.CodeLibDef;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.DivHtmlDef;
import org.maskat.framework.screendef.FrameDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.ImageDef;
import org.maskat.framework.screendef.LabelDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.PopupDef;
import org.maskat.framework.screendef.RadioDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.framework.screendef.TextDef;
import org.maskat.framework.screendef.TreeNodeDef;
import org.maskat.framework.screendef.TreeViewDef;
import org.maskat.framework.screendef.customize.IPluginComponentDef;
import org.maskat.ide.gef.editpolicies.LabelDirectEditPolicy;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.MyXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.CodeLibFigure;
import org.maskat.ide.gef.figure.ImageFigure;
import org.maskat.ide.gef.figure.LayoutFigure;
import org.maskat.ide.gef.figure.MaskatGridFigure;
import org.maskat.ide.gef.figure.MaskatLabel;
import org.maskat.ide.gef.figure.NullBorder;
import org.maskat.ide.gef.figure.PopupFigure;
import org.maskat.ide.gef.figure.SplitterFigure;
import org.maskat.ide.gef.tools.TextCellEditorLocator;
import org.maskat.ide.gef.tools.TextDirectEditManager;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnBlurSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnCellEditSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnCellWriteSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnClickSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnCloseSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnDbleClickSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnFocusSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnLoadSettable;
import org.maskat.ide.tabbedproperties.sectionfilter.IOnSetDisplaySettable;

public class ComponentEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {
	static final Image CHECKBOXUNCHECKED = createImage("/images/checkboxenabledoff.gif"), //$NON-NLS-1$
			RADIOUNCHECKED = createImage("/images/radioboxenableoff.gif"), //$NON-NLS-1$
			COMBOBOXDROPDOWN = createImage("/images/comboboxdropdown.gif"); //$NON-NLS-1$

	private static Image createImage(String name) {
		InputStream stream = ComponentEditPart.class.getResourceAsStream(name);
		Image image = new Image(null, stream);
		try {
			stream.close();
		} catch (IOException ioe) {
		}
		return image;
	}

	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	public static Font BIG_FONT = new Font(null, "Arial", 12, 0);

	// public static Font FONT_COMP_TYPE = new Font(null, "Arial", 8, SWT.BOLD |
	// SWT.ITALIC);

	public void activate() {
		super.activate();
		IComponentDef model = (IComponentDef) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		IComponentDef model = (IComponentDef) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {

		IComponentDef model = (IComponentDef) getModel();
		IFigure figure = createFigure(model);
		XYLayout layout = new XYLayout();
		figure.setLayoutManager(layout);
		return figure;
	}

	private IFigure createFigure(IComponentDef model) {
		Label label = null;
		if (model instanceof LabelDef) {
			label = new Label();
			label.setFont(DEFAULT_FONT);
			// Ogƃ}[W̐ݒ
			label.setBorder(new NullBorder());
			label.setText(((LabelDef) model).getText());
			// Rectangle dim = label.getTextBounds();
			// model.setWidth(dim.width + 12);
		}
		if (model instanceof TextDef) {
			label = new Label();
			label.setFont(DEFAULT_FONT);
			label.setText(((TextDef) model).getInitValue());
			// Ogƃ}[W̐ݒ
			label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(1)));
		}
		if (model instanceof ButtonDef) {
			label = new Label();
			label.setFont(DEFAULT_FONT);
			// Ogƃ}[W̐ݒ
			label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(1)));
			label.setBackgroundColor(ColorConstants.button);
			label.setOpaque(true);
			label.setText(((ButtonDef) model).getTitle());
			adjustModelPreferredSize(label, model);
		}
		if (model instanceof CheckboxDef) {
			CheckboxDef cd = (CheckboxDef) model;
			label = new Label(cd.getText(), CHECKBOXUNCHECKED);
			label.setFont(DEFAULT_FONT);
			label.setLabelAlignment(PositionConstants.LEFT);
			adjustModelPreferredSize(label, model);
		}
		if (model instanceof RadioDef) {
			RadioDef rd = (RadioDef) model;
			label = new Label(rd.getText(), RADIOUNCHECKED);
			label.setFont(DEFAULT_FONT);
			label.setLabelAlignment(PositionConstants.LEFT);
			adjustModelPreferredSize(label, model);
		}
		if (model instanceof ImageDef) {
			label = new ImageFigure();
			label.setBorder(new LineBorder());
			adjustModelPreferredSize(label, model);
		}
		if (model instanceof CodeLibDef) {
			label = new CodeLibFigure();
			CodeLibDef codeLib = (CodeLibDef) model;
			model.setHeight(20);
			if (codeLib.hasLabelInput()) {
				((CodeLibFigure) label).setWithLabelInput(true);
			} else {
				((CodeLibFigure) label).setWithLabelInput(false);
			}
		}
		if (model instanceof GridDef) {
			MaskatGridFigure gridFigure = new MaskatGridFigure((GridDef) model);
			gridFigure.setFont(DEFAULT_FONT);
			gridFigure.setBorder(new LineBorder());
			return gridFigure;
		}

		if (model instanceof LayoutDef) {
			LayoutFigure figure = new LayoutFigure();
			return figure;
		}
		if (model instanceof DivHtmlDef) {
			label = new Label();
			label.setText(((DivHtmlDef) model).getHtml());
			label.setBorder(new LineBorder(1));
		}
		if (model instanceof PopupDef) {
			label = new PopupFigure((PopupDef) model);
			label.setBorder(new LineBorder(1));
		}
		if (model instanceof IPluginComponentDef) {
			label = new Label();
			label.setBorder(new LineBorder(1));
			// label.setText(((IPluginComponentDef)
			// model).getProxy().getQName());
			// label.setFont(FONT_COMP_TYPE);
		}
		if (model instanceof IContainerDef && label == null) {
			label = new MaskatLabel();
			label.setBorder(new LineBorder(1));
		}

		if (label == null)
			return new Figure();
		return label;
	}

	/**
	 * CAEg`ɌĂTCY`ɑ΂āAł͑TCYvZ(Ƃ΁A<br>
	 * Label͑̕Sł悤ɒ,ImagẽTCY20X10ƌŒ)
	 * 
	 * @param figure
	 * @param model
	 */
	private void adjustModelPreferredSize(Figure figure, IComponentDef model) {
		if (model instanceof ImageDef) {
			model.setWidth(20);
			model.setHeight(10);
			return;
		}
		// if (model instanceof GridDef) {
		// GridDef gridModel = (GridDef) model;
		// int headerWidth = gridModel.headerTotalWidth();
		// if (headerWidth == 0) {
		// gridModel.setWidth(100);
		// } else {
		// gridModel.setWidth(headerWidth);
		// }
		// return;
		// }
		Dimension dim = figure.getPreferredSize();
		model.setWidth(dim.width);
		model.setHeight(dim.height);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new MyXYLayoutEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#getModelChildren()
	 */
	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof IBasicDef) {
			result = ((IBasicDef) getModel()).getUnmodifiableChildren();
		}
		// if (getModel() instanceof GridDef) {
		// result = ((GridDef) getModel()).getUnmodifiableChildren();
		// }
		if (result != null)
			return result;

		return super.getModelChildren();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#refreshVisuals()
	 */
	protected void refreshVisuals() {
		// TODO If the component's width or size is smaller than 0, we should
		// set one "minimal" width or size, so that the component is "visible"
		// on the IDE's GUI.
		// TODO Some components' width or height property is "invalid", which
		// means that even if the size of the component is set, the appearance
		// may differ from the setting. Eg. Grid's width equals to the total
		// width of the GridHeader. Button's height is fixed.

		IComponentDef comp = (IComponentDef) getModel();
		Rectangle constraint;
		if (comp instanceof LabelDef) {
			// Ogƃ}[W̐ݒ
			constraint = ((Label) getFigure()).getTextBounds();
			constraint.x = comp.getLeft();
			constraint.y = comp.getTop();
			constraint.height = comp.getHeight();
			if (constraint.width == 0)
				constraint.width = 25;
		} else if (comp instanceof GridDef) {
			int tableWidth = ((GridDef) comp).headerTotalWidth();
			if (tableWidth <= 0)
				tableWidth = 100;// e[ũftHg
			constraint = new Rectangle(comp.getLeft(), comp.getTop(), tableWidth, comp
					.getHeight());
		} else {
			// ̎擾
			constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(),
					comp.getHeight());
		}
		if (getParent().getModel() instanceof PopupDef) {
			constraint.y += 20;
		}
		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	private boolean extendComponentHasEvent(IPluginComponentDef def, String eventName) {
		return def.getProxy().hasEvent(eventName);
	}

	public Object getAdapter(Class key) {
		if (IPropertySource.class == key) {
			return null;
			// PropertySheetEntrył͂̃\bhĂяoāA
			// nullԋpAEclipsePropertySheetr[ŕ\ȂB
			// MaskatPropertySheetEntrył͓ꏈ(getPropertySourceQ)
		}
		if (key.equals(IOnClickSettable.class)) {
			// TODO instancef̃WbN͈VNXɈڂ
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnClickSettable.ID)) {
					return IOnClickSettable.onclickOK;
				}
			}
			if (getModel() instanceof ButtonDef || getModel() instanceof ImageDef
					|| getModel() instanceof GridDef || getModel() instanceof CheckboxDef
					|| getModel() instanceof RadioDef
					|| getModel() instanceof TreeViewDef
					|| getModel() instanceof ComboDef) {
				return IOnClickSettable.onclickOK;
			}
		} else if (key.equals(IOnDbleClickSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnDbleClickSettable.ID)) {
					return IOnDbleClickSettable.onDbleClickOK;
				}
			}
			if (getModel() instanceof GridDef) {
				return IOnDbleClickSettable.onDbleClickOK;
			}
		} else if (key.equals(IOnSetDisplaySettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnSetDisplaySettable.ID)) {
					return IOnSetDisplaySettable.onsetDisplayOK;
				}
			}
			if (getModel() instanceof FrameDef) {
				return IOnSetDisplaySettable.onsetDisplayOK;
			}
		} else if (key.equals(IOnLoadSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnLoadSettable.ID)) {
					return IOnLoadSettable.onLoadOK;
				}
			}
			if (getModel() instanceof LayoutDef) {
				return IOnLoadSettable.onLoadOK;
			}
		} else if (key.equals(IOnBlurSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnBlurSettable.ID)) {
					return IOnBlurSettable.onBlurOK;
				}
			}
			if (getModel() instanceof TextDef) {
				return IOnBlurSettable.onBlurOK;
			}
		} else if (key.equals(IOnFocusSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnFocusSettable.ID)) {
					return IOnFocusSettable.onFocusOK;
				}
			}
			if (getModel() instanceof TextDef) {
				return IOnFocusSettable.onFocusOK;
			}
		} else if (key.equals(IOnCellEditSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnCellEditSettable.ID)) {
					return IOnCellEditSettable.onCellEditOK;
				}
			}
			if (getModel() instanceof GridDef) {
				return IOnCellEditSettable.onCellEditOK;
			}
		} else if (key.equals(IOnCellWriteSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnCellWriteSettable.ID)) {
					return IOnCellWriteSettable.onCellwriteOK;
				}
			}
			if (getModel() instanceof GridDef) {
				return IOnCellWriteSettable.onCellwriteOK;
			}
		} else if (key.equals(IOnCloseSettable.class)) {
			if (getModel() instanceof IPluginComponentDef) {
				if (extendComponentHasEvent((IPluginComponentDef) getModel(),
						IOnCloseSettable.ID)) {
					return IOnCloseSettable.onCloseOK;
				}
			}
			if (getModel() instanceof PopupDef) {
				return IOnCloseSettable.onCloseOK;
			}
		}
		return super.getAdapter(key);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		IComponentDef comp = (IComponentDef) getModel();
		if ("text".equals(evt.getPropertyName())) {
			// \̕ύX
			if (comp instanceof LabelDef) {
				((Label) getFigure()).setText((String) evt.getNewValue());
			}
			if (comp instanceof RadioDef) {
				((Label) getFigure()).setText((String) evt.getNewValue());
			}
			// \̕ύX
			if (comp instanceof GridDef) {
				this.getFigure().repaint();
			}
			if (comp instanceof CheckboxDef) {
				((Label) getFigure()).setText((String) evt.getNewValue());
			}
			if (comp instanceof TextDef) {
				((Label) getFigure()).setText((String) evt.getNewValue());
			}
		}
		if ("title".equals(evt.getPropertyName())) {
			if (comp instanceof ButtonDef) {
				((Label) getFigure()).setText((String) evt.getNewValue());
			}
			getFigure().repaint();
		}
		if ("orientation".equals(evt.getPropertyName())) {
			if (comp instanceof SplitterDef) {
				((SplitterFigure) getFigure()).repaint();
			}
		}
		if ("gridHeaderTitle".equals(evt.getPropertyName())
				|| "gridHeaderWidth".equals(evt.getPropertyName())
				|| "lineHeight".equals(evt.getPropertyName())) {
			if (comp instanceof GridDef) {
				for (Iterator it = this.getChildren().iterator(); it != null
						&& it.hasNext();) {
					((AbstractGraphicalEditPart) it.next()).refresh();
				}
				this.getFigure().repaint();
			}
		}
		if ("boolWithLabel".equals(evt.getPropertyName())) {
			if (comp instanceof CodeLibDef) {
				((CodeLibFigure) getFigure()).setWithLabelInput(((CodeLibDef) comp)
						.hasLabelInput());
				this.getFigure().repaint();
			}
		}
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refresh();
			if (comp instanceof GridDef) {
				for (Iterator it = this.getChildren().iterator(); it != null
						&& it.hasNext();) {
					((AbstractGraphicalEditPart) it.next()).refresh();
				}
				this.getFigure().repaint();
			}
		}
		refreshVisuals();
	}

	/**
	 * Search for editpart(s) belongs to the editPart, whose model have the
	 * specified name. And switch the visibility of the editPart's figure. It
	 * could be choosen whether to switch all found editpart or the first one
	 * found.
	 * 
	 * @param editPart
	 * @param name
	 * @param firstOnly
	 * @return
	 */
	protected boolean switchNamedComponentVisibility(AbstractGraphicalEditPart editPart,
			String name, boolean firstOnly) {
		List children = editPart.getChildren();
		if (children == null)
			return false;

		boolean found = false;
		Iterator it = children.iterator();
		while (it != null && it.hasNext()) {
			AbstractGraphicalEditPart child = (AbstractGraphicalEditPart) it.next();
			Object model = child.getModel();
			if (model instanceof IComponentDef) {
				if (name.equals(((IComponentDef) model).getName())) {
					IFigure figure = child.getFigure();
					if (figure != null) {
						figure.setVisible(!figure.isVisible());
						found = true;
						if (firstOnly)
							return true;
					}
				}
			}
			if (switchNamedComponentVisibility(child, name, firstOnly)) {
				found = true;
			}
			if (found && firstOnly)
				return true;
		}
		return found;
	}

	public void performRequest(Request req) {
		if (REQ_OPEN.equals(req.getType())) {
			Object model = this.getModel();
			if (model instanceof LabelDef || model instanceof TextDef
					|| model instanceof ButtonDef || model instanceof RadioDef
					|| model instanceof CheckboxDef || model instanceof TreeNodeDef)
				new TextDirectEditManager(this, null, new TextCellEditorLocator(
						getFigure())).show();
		}
	}
}
