/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.IBasicDef;

public class AddBasicDefCommand extends Command {

	private IBasicDef parent;

	private IBasicDef child;

	private IBasicDef originalParent;

	private int originalIdx;

	public AddBasicDefCommand(IBasicDef parent, IBasicDef child) {
		super("ǉ");
		this.parent = parent;
		this.child = child;
	}

	// public boolean canExecute() {
	// // parentchild^O̒ǉ邱Ƃ͎dlɉ\ǂf
	// // XXX basicDef̐eq֌W|V[@\͕Kvł!!!!
	// if (parent instanceof TabFolderDef) {
	// if (!(child instanceof TabItemDef || child instanceof TabDef)) {
	// return false;
	// }
	// }
	// if (child instanceof TabItemDef || child instanceof TabDef) {
	// if (!(parent instanceof TabFolderDef)) {
	// return false;
	// }
	// }
	//		
	// return true;
	// }

	public void execute() {
		originalParent = child.getParentDef();
		if (originalParent != null) {
			originalIdx = originalParent.getChildIdx(child);
			if (originalIdx == -1) {
				// childoriginalParent̎qm[hł͂Ȃ
				originalParent = null;
			} else {
				// childoriginalParent̎qm[h
				originalParent.removeChild(child);
			}
		}
		parent.addChild(child);
	}

	public void undo() {
		parent.removeChild(child);
		if (originalParent != null)
			originalParent.addChildToIdx(child, originalIdx);
	}

	public boolean canUndo() {
		return true;
	}
}
