/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.maskat.framework.BasicDef;

/**
 * 
 * @author shengshen
 * 
 */
public abstract class ComponentDef extends BasicDef implements IComponentDef {

	public final static int DEFAULT_HEIGHT = 20;

	private String name;

	private String tabIndex;

	/**
	 * CAEg`Fparent
	 */
	private String attrParent;

	private int left, top, width = 40, height = DEFAULT_HEIGHT;

	public ComponentDef() {
	}

	public void addJavaScript(String content) {
		JavaScriptDef javascriptDef = new JavaScriptDef();
		javascriptDef.setContent(content);
		addChild(javascriptDef);
	}

	// public void addDivHtml(String divHtml) {
	// DivHtmlDef divHtmlDef = new DivHtmlDef();
	// divHtmlDef.setHtml(divHtml);
	// addChild(divHtmlDef);
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getParent()
	 */
	public IContainerDef getParent() {
		if (getParentDef() instanceof IContainerDef) {
			return (IContainerDef) getParentDef();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setParent(org.maskat.framework.screendef.ContainerDef)
	 */
	// public void setParent(IContainerDef parent) {
	// this.parent = parent;
	// }
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getLayoutDef()
	 */
	public LayoutDef getLayoutDef() {
		if (getParentDef() instanceof IComponentDef) {
			return ((IComponentDef) getParentDef()).getLayoutDef();
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getName()
	 */
	public String getName() {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getTabIndex() {
		return tabIndex;
	}

	public void setTabIndex(String tabIndex) {
		this.tabIndex = tabIndex;
	}

	public String getAttrParent() {
		return attrParent;
	}

	public void setAttrParent(String attrParent) {
		this.attrParent = attrParent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setHeight(int)
	 */
	public void setHeight(int height) {
		this.height = height;
		firePropertyChange("constraint", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getLeft()
	 */
	public int getLeft() {
		return left;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setLeft(int)
	 */
	public void setLeft(int left) {
		this.left = left;
		firePropertyChange("constraint", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getTop()
	 */
	public int getTop() {
		return top;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setTop(int)
	 */
	public void setTop(int top) {
		this.top = top;
		firePropertyChange("constraint", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setWidth(int)
	 */
	public void setWidth(int width) {
		this.width = width;
		firePropertyChange("constraint", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IComponentDef#setConstraint(int, int,
	 *      int, int)
	 */
	public void setConstraint(int left, int top, int width, int height) {
		this.left = left;
		this.top = top;
		this.width = width;
		this.height = height;
		firePropertyChange("constraint", "", null);
	}

	// f̏ԕωʒm郊XĩXg
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener l) {
		listeners.addPropertyChangeListener(l);
	}

	public void firePropertyChange(String propName, Object oldValue, Object newValue) {
		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	public void removePropertyChangeListener(PropertyChangeListener l) {
		listeners.removePropertyChangeListener(l);
	}

	public Object clone() throws CloneNotSupportedException {
		ComponentDef def = (ComponentDef) super.clone();
		def.listeners = new PropertyChangeSupport(def);
		return def;
	}
}
