/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.eventdef;

/**
 * Instance of this interface represents a "source" of event definition. The
 * "source" could be one event definition persistence or several of them.<br>
 * <code>IEventDefSource</code> is responsible for retrieving/writing data
 * from/to "source".
 * 
 * @author shengshen
 * 
 */
public interface IEventDefSource {

	/**
	 * Get all the event definition from the source.
	 * 
	 * @return Should never return null.
	 */
	public Layout[] getDefs();

	/**
	 * Find the component's event definition from the source. If there is not
	 * such a component definition. The implementation should add one "empty"
	 * Component to the source.
	 * 
	 * @param componentName
	 * @return Should never return null.
	 */
	public Component findComponent(String componentName);

	/**
	 * Read the event definition from the persistence. <code>load</code>
	 * method <em>must</em> be called before any other methods could be called
	 * for this object.
	 * 
	 * @throws Exception
	 */
	public void load() throws Exception;

	/**
	 * Write the event definition to the persistence.
	 * 
	 * @return The strings that are the contents written to the event definition
	 *         persistence.
	 * @throws Exception
	 */
	public String[] save() throws Exception;

}