/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.maskat.framework.BasicDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.framework.screendef.TabFolderDef;
import org.maskat.framework.screendef.TabItemDef;
import org.maskat.framework.screendef.TreeNodeDef;
import org.maskat.framework.screendef.TreeViewDef;
import org.maskat.ide.MaskatIDEPlugin;
import org.maskat.ide.gef.commands.AddBasicDefCommand;
import org.maskat.ide.gef.editparts.ComponentEditPart;

public class PasteComponentAction
extends SelectionAction {
    private BasicDef targetDef = null;
    static /* synthetic */ Class class$0;

    public PasteComponentAction(IWorkbenchPart part) {
        super(part);
        this.setId(ActionFactory.PASTE.getId());
        this.setText(GEFMessages.PasteAction_Label);
        this.setToolTipText(GEFMessages.PasteAction_Tooltip);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    protected boolean calculateEnabled() {
        if (!this.checkClipboard()) {
            return false;
        }
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return false;
        }
        if (objects.size() > 1) {
            return false;
        }
        Object selectedObj = objects.get(0);
        if (!(selectedObj instanceof EditPart)) {
            return false;
        }
        Object model = ((EditPart)selectedObj).getModel();
        if (!(model instanceof BasicDef)) {
            return false;
        }
        this.targetDef = (BasicDef)model;
        return this.canBePasted();
    }

    private boolean checkClipboard() {
        Object clipboardContent = Clipboard.getDefault().getContents();
        if (!(clipboardContent instanceof List)) {
            return false;
        }
        int i = 0;
        while (i < ((List)clipboardContent).size()) {
            if (!(((List)clipboardContent).get(i) instanceof BasicDef)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        BasicDef def;
        if (!this.checkClipboard()) {
            return;
        }
        Command command = null;
        List basicDefList = (List)Clipboard.getDefault().getContents();
        ArrayList<BasicDef> source = new ArrayList<BasicDef>();
        Iterator it = basicDefList.iterator();
        while (it.hasNext()) {
            def = (BasicDef)it.next();
            try {
                BasicDef clone = (BasicDef)def.clone();
                source.add(clone);
            }
            catch (CloneNotSupportedException e) {
                MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)"\u8cbc\u308a\u4ed8\u3051\u64cd\u4f5c\u5931\u6557", (String)"\u8cbc\u308a\u4ed8\u3051\u64cd\u4f5c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u8a73\u3057\u304f\u306f\u30a8\u30e9\u30fc\u30ed\u30b0\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                MaskatIDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.maskat.ide.gef", 4, e.getMessage(), (Throwable)e));
                return;
            }
        }
        it = source.iterator();
        while (it.hasNext()) {
            def = (BasicDef)it.next();
            if (def instanceof IComponentDef && this.targetDef instanceof IComponentDef) {
                IComponentDef compDef = (IComponentDef)((Object)def);
                compDef.setLeft(compDef.getLeft() + 10);
                compDef.setTop(compDef.getTop() + 10);
                IComponentDef targetComp = (IComponentDef)((Object)this.targetDef);
                if (!(targetComp instanceof LayoutDef)) {
                    if (targetComp instanceof TabItemDef) {
                        TabFolderDef tabFolder = (TabFolderDef)((TabItemDef)targetComp).getParent();
                        if (tabFolder.getHeight() - 20 < compDef.getTop()) {
                            compDef.setTop(tabFolder.getHeight() - 40);
                        }
                        if (tabFolder.getWidth() - 20 < compDef.getLeft()) {
                            compDef.setLeft(tabFolder.getWidth() - 40);
                        }
                    } else {
                        if (targetComp.getHeight() - 20 < compDef.getTop()) {
                            compDef.setTop(targetComp.getHeight() - 40);
                        }
                        if (targetComp.getWidth() - 20 < compDef.getLeft()) {
                            compDef.setLeft(targetComp.getWidth() - 40);
                        }
                    }
                }
                targetComp.getLayoutDef().setAppropriateNameForComponent(compDef);
                if (this.targetDef instanceof TreeViewDef) {
                    TreeNodeDef rootNode;
                    TreeViewDef treeViewDef = (TreeViewDef)this.targetDef;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.maskat.framework.screendef.TreeNodeDef");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((rootNode = (TreeNodeDef)treeViewDef.getChildByTypeIdx(clazz, 0)) != null) {
                        this.targetDef = rootNode;
                    }
                }
            }
            command = command == null ? this.genCommand(this.targetDef, def) : command.chain(this.genCommand(this.targetDef, def));
        }
        this.execute(command);
        ArrayList<Object> toCopy = new ArrayList<Object>();
        Iterator it2 = source.iterator();
        while (it2.hasNext()) {
            BasicDef def2 = (BasicDef)it2.next();
            try {
                toCopy.add(def2.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        Clipboard.getDefault().setContents(toCopy);
    }

    private Command genCommand(BasicDef parentDef, BasicDef childDef) {
        return new AddBasicDefCommand(this.targetDef, childDef);
    }

    private boolean canBePasted() {
        List basicDefList = (List)Clipboard.getDefault().getContents();
        ArrayList<ComponentEditPart> sourceEPList = new ArrayList<ComponentEditPart>();
        Iterator it = basicDefList.iterator();
        while (it.hasNext()) {
            BasicDef def = (BasicDef)it.next();
            if (def instanceof GridHeaderDef) {
                return this.targetDef instanceof GridDef;
            }
            ComponentEditPart ep = new ComponentEditPart();
            ep.setModel(def);
            sourceEPList.add(ep);
        }
        List objects = this.getSelectedObjects();
        EditPart targetEP = (EditPart)objects.get(0);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"add children");
        request.setEditParts(sourceEPList);
        Command command = targetEP.getCommand((Request)request);
        return command == null ? false : command.canExecute();
    }
}

