package org.maskat.demo.databinding.cm_bt1.vo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import javax.servlet.http.HttpServletRequest;


import org.maskat.demo.AbstractValueObj;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;

public class ValueObj extends AbstractValueObj {

  public String value;

  public ValueObj(HttpServletRequest req) {
    super(req);

    try {
      BufferedReader reader = new BufferedReader(req.getReader());
      String line = null;
      String xml = "";
      while ((line = reader.readLine()) != null) {
        xml += line;
      }
      System.out.println("受信電文: " + xml);
      DOMParser parser = new DOMParser();
      parser.parse(new InputSource(new StringReader(xml)));

      NodeList paramNodeList = parser.getDocument().getChildNodes().item(0).getChildNodes();
      for (int i = 0; i < paramNodeList.getLength(); i++) {
        Node node = paramNodeList.item(i);
        if ("value".equals(node.getNodeName())) {
          try {
            value = node.getChildNodes().item(0).getNodeValue();
          } catch (Exception e) {
          }
        }
      }
    } catch (IOException e) {
      e.printStackTrace();
      return;
    } catch (SAXException e) {
      e.printStackTrace();
    }

  }

  public String tempGetXML() {
    String newValue = "";
    if ("cm_cm1_ci1".equals(value)){ newValue = "cm_cm2_ci2"; }
    else if ("cm_cm1_ci2".equals(value)){ newValue = "cm_cm2_ci3"; }
    else if ("cm_cm1_ci3".equals(value)){ newValue = "cm_cm2_ci4"; }
    else if ("cm_cm1_ci4".equals(value)){ newValue = "cm_cm2_ci1"; }
    return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><maskat><value>" + newValue + "</value></maskat>";
  }

}
