package org.maskat.demo.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;

public class GurumeServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	private static String[][] datas = new String[][] {
			{ "0001", "ザ・銀座 銀座一丁目店", "東京都中央区銀座1-○-○", "1", "500", "0", "35.67523", "139.766463",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0002", "ふくふく 銀座一丁目店", "東京都中央区銀座1-○-○", "0", "1500", "1", "35.674822", "139.766579",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0003", "まの字 銀座一丁目店", "東京都中央区銀座1-○-○", "1", "5500", "0", "35.67458", "139.767644",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0004", "タベモノヤ 銀座一丁目店", "東京都中央区銀座1-○-○", "2", "700", "1", "35.673963", "139.768274",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0005", "M・S・K・A・T", "東京都中央区銀座1-○-○", "0", "2000", "0", "35.674397", "139.768714",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0006", "中国薬膳料理 銀座苺 一丁目店", "東京都中央区銀座1-○-○", "2", "6000", "1", "35.673332", "139.769333",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0007", "鯖寿司", "東京都中央区銀座2-○-○", "0", "900", "0", "35.67438", "139.766571",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0008", "さつまいも芋庵", "東京都中央区銀座2-○-○", "0", "2500", "1", "35.673716", "139.766701",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0009", "ＧＩＮＺＡ Ｗｉｎｅ Ｄｉｎｉｎｇ 葡萄", "東京都中央区銀座2-○-○", "1", "7000", "0", "35.673662", "139.767228",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0010", "Italian Dining Maskat", "東京都中央区銀座2-○-○", "0", "500", "1", "35.673403", "139.767724",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0011", "銀座一家", "東京都中央区銀座2-○-○", "0", "1500", "0", "35.672733", "139.76771",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0012", "宮崎地鶏 コクバル 銀座柳通り店", "東京都中央区銀座2-○-○", "1", "5500", "1", "35.672634", "139.769105",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0013", "下町和食 かつ屋", "東京都中央区銀座3-○-○", "0", "700", "0", "35.673083", "139.764745",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0014", "キッチン・マスカット 銀座店", "東京都中央区銀座3-○-○", "2", "2000", "1", "35.673483", "139.765781",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0015", "炭火焼き鳥酒房 ブドウ", "東京都中央区銀座3-○-○", "0", "6000", "0", "35.673225", "139.766087",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0016", "鰯ぎんざ", "東京都中央区銀座3-○-○", "1", "900", "1", "35.672261", "139.766676",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0017", "お座敷個室 マスカット", "東京都中央区銀座3-○-○", "2", "2500", "0", "35.671731", "139.766756",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0018", "銀座 ますかっと～MASKAT～", "東京都中央区銀座3-○-○", "1", "7000", "1", "35.671746", "139.768053",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0019", "北海道 海老料理ユッケ 銀座店", "東京都中央区銀座4-○-○", "1", "500", "0", "35.672544", "139.763691",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0020", "ＧＩＮＺＡ ＭＡＳＫＡＴ", "東京都中央区銀座4-○-○", "0", "1500", "1", "35.672342",	"139.765296",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0021", "イタリア 銀座", "東京都中央区銀座4-○-○", "0", "5500", "0", "35.671682", "139.766171",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0022", "白胡麻 銀座本店", "東京都中央区銀座4-○-○", "0", "700", "1", "35.671192", "139.765542",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0023", "くだもの屋 銀座店", "東京都中央区銀座4-○-○", "2", "2000", "0", "35.671081", "139.767038",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0024", "関西料理 金蜜柑", "東京都中央区銀座4-○-○", "1", "6000", "1", "35.670382", "139.767168",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0025", "食い倒れ25", "東京都中央区銀座5-○-○", "0", "900", "0", "35.672164", "139.763212",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0026", "和風創菜喰いどころ 「ますかっと」", "東京都中央区銀座5-○-○", "1", "2500", "1", "35.670607", "139.764004",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0027", "やきとん やきとり 焼酎 「マスカット」", "東京都中央区銀座5-○-○", "1", "7000", "0", "35.671314", "139.764503",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0028", "葡萄 魚一", "東京都中央区銀座5-○-○", "2", "500", "1", "35.67056", "139.764886",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0029", "炭火焼 ますかっと", "東京都中央区銀座5-○-○", "2", "1500", "0", "35.669808", "139.765555",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0030", "串工房 SHIO", "東京都中央区銀座5-○-○", "0", "5500", "1", "35.669782", "139.766087",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0031", "イタリーパスタ 銀座店", "東京都中央区銀座6-○-○", "0", "700", "0", "35.670414", "139.76312",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0032", "銀座グリル 本店", "東京都中央区銀座6-○-○", "2", "2000", "1", "35.670373", "139.763583",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0033", "炭火焼居酒屋 銀座", "東京都中央区銀座6-○-○", "1", "6000", "0", "35.669023", "139.764453",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0034", "旬彩 魚 SALMON", "東京都中央区銀座6-○-○", "0", "900", "1", "35.669357", "139.764811",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0035", "中国大陸料理 香港 銀座店", "東京都中央区銀座6-○-○", "2", "2500", "0", "35.669207", "139.765299",
				"5～8名の個室完備 \r20名～貸切も可能 \rコースは選べる3コース3000円～ \r" },
			{ "0036", "ラ・ムー銀座", "東京都中央区銀座6-○-○", "1", "7000", "1", "35.668863", "139.765491",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0037", "ピエール・マスカット", "東京都中央区銀座7-○-○", "0", "500", "0", "35.670192", "139.76161",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0038", "飲茶カフェ タオチャン", "東京都中央区銀座7-○-○", "2", "1500", "1", "35.669286", "139.761416",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0039", "奈良鹿 銀座店", "東京都中央区銀座7-○-○", "2", "5500", "0", "35.669514", "139.762095",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0040", "Ｏ-ＭＡＳＫＡＴ", "東京都中央区銀座7-○-○", "0", "700", "1", "35.668448", "139.763015",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0041", "上海料理 ヒガシ", "東京都中央区銀座7-○-○", "2", "2000", "0", "35.667917", "139.763348",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0042", "ハンチャ 銀座店", "東京都中央区銀座7-○-○", "2", "6000", "1", "35.667837", "139.764243",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0043", "Ｌｏｃaｌ ＴＡＢＬＥ ＭＡ 銀座店", "東京都中央区銀座8-○-○", "1", "900", "0", "35.669111", "139.760328",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0044", "中国名菜 悟飯", "東京都中央区銀座8-○-○", "2", "2500", "1", "35.668253", "139.760163",
				"限定コース！今年は3つのコースからお選びいただけます！ \rゆったりとした空間の落ち着いた雰囲気の店内 \r個室は6名様～30名様まで人数に合わせてお選びいただけます" },
			{ "0045", "小春日和", "東京都中央区銀座8-○-○", "2", "7000", "0", "35.668695", "139.760545",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" },
			{ "0046", "マスカット料理 七吉", "東京都中央区銀座8-○-○", "0", "500", "1", "35.668403", "139.761457",
				"****限定コース飲放3Hつき****円→****円！！ \r料理10品デザート付 \r 今ならランチコースも****円→****円！！ \rクーポンで更にお得！この機会にぜひ！！ \rお客さまのご来店を心よりお待ちいたしております。" },
			{ "0047", "Japanese Maskat", "東京都中央区銀座8-○-○", "1", "1500", "0", "35.667659", "139.762075",
				"銀座「****」、しっとりと落ち着いた店内！ \r個室も完備！！接待やご宴会などにもご利用いただけます。\r月～木限定コース 2名様で6,000円 \rお一人様でも気楽にご利用いただけます。" },
			{ "0048", "ステーキハウス 銀座店", "東京都中央区銀座8-○-○", "0", "5500", "1", "35.667633", "139.763003",
				"旬の食材を活かした絶品料理の数々！ \rおいしさを絶妙なるハーモニーとして豊かに表現しております。 \r****限定コースがクーポンでオトク！ \rスタッフ一同お待ち申し上げます。" }
	};

	private static boolean western, japanese, chinese, withCoupon;

	private static int budgetLow, budgetHigh;

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		// XML解析部分、フレームワークでやってくれるはず。。
		try {
			BufferedReader reader = new BufferedReader(request.getReader());
			String line = null;
			String xml = "";
			while ((line = reader.readLine()) != null) {
				xml += line;
			}
			getParam(xml);

			List dataList = new ArrayList();
			for (int i = 0; i < datas.length; i++) {
				dataList.add(datas[i]);
			}
			filterFoodType(dataList);
			filterLowBudget(dataList);
			filterHighBudget(dataList);
			filterCoupon(dataList);

			// from dataList to XML
			String returnXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><result>";
			for (int i = 0; i < dataList.size(); i++) {
				String[] data = (String[]) dataList.get(i);
				returnXML += "<data>";
				returnXML += "<id>" + data[0] + "</id>";
				returnXML += "<name>" + toXMLData(data[1]) + "</name>";
				returnXML += "<address>" + toXMLData(data[2]) + "</address>";
				if ("0".equals(data[3])) {
					returnXML += "<food>洋</food>";
				} else if ("1".equals(data[3])) {
					returnXML += "<food>和</food>";
				} else {
					returnXML += "<food>中</food>";
				}
				returnXML += "<budget>" + data[4] + "</budget>";
				returnXML += "<coupon>" + ("1".equals(data[5]) ? "あり" : "なし")
						+ "</coupon>";
				returnXML += "<lat>" + data[6] + "</lat>";
				returnXML += "<lng>" + data[7] + "</lng>";
				returnXML += "<info>" + toXMLData(data[8]) + "</info>";
				returnXML += "</data>";
			}
			returnXML += "</result>";
			response.setContentType("text/xml;charset=UTF-8");
			PrintWriter out = response.getWriter();
			out.println(returnXML);
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		}
	}

	private String toXMLData(String data) {
		if (data == null)
			return null;
		return data.replaceAll("\\&", "&amp;").replaceAll("<", "&lt;").replaceAll(">",
				"&gt;");
	}

	private void filterFoodType(List dataList) {
		for (Iterator it = dataList.iterator(); it.hasNext();) {
			String[] data = (String[]) it.next();
			if (western == false && data[3] == "0") {
				it.remove();
				continue;
			}
			if (japanese == false && data[3] == "1") {
				it.remove();
				continue;
			}
			if (chinese == false && data[3] == "2") {
				it.remove();
				continue;
			}
		}
	}

	private void filterLowBudget(List dataList) {
		if (budgetLow == 0)
			return;
		for (Iterator it = dataList.iterator(); it.hasNext();) {
			String[] data = (String[]) it.next();
			int budget = Integer.parseInt(data[4]);
			if (budget < budgetLow) {
				it.remove();
			}
		}
	}

	private void filterHighBudget(List dataList) {
		if (budgetHigh == 0)
			return;
		for (Iterator it = dataList.iterator(); it.hasNext();) {
			String[] data = (String[]) it.next();
			int budget = Integer.parseInt(data[4]);
			if (budget > budgetHigh) {
				it.remove();
			}
		}

	}

	private void filterCoupon(List dataList) {
		if (withCoupon == false)
			return;

		for (Iterator it = dataList.iterator(); it.hasNext();) {
			String[] data = (String[]) it.next();
			if (!"1".equals(data[5])) {
				it.remove();
			}
		}
	}

	private static void getParam(String xml) throws SAXException, IOException {
		DOMParser parser = new DOMParser();
		parser.parse(new InputSource(new StringReader(xml)));

		NodeList paramNodeList = parser.getDocument().getChildNodes().item(0)
				.getChildNodes();
		for (int i = 0; i < paramNodeList.getLength(); i++) {
			Node node = paramNodeList.item(i);
			if ("western".equals(node.getNodeName())) {
				try {
					western = Boolean.parseBoolean(node.getChildNodes().item(0)
							.getNodeValue());
				} catch (Exception e) {
				}
			}
			if ("japanese".equals(node.getNodeName())) {
				try {
					japanese = Boolean.parseBoolean(node.getChildNodes().item(0)
							.getNodeValue());
				} catch (Exception e) {
				}
			}
			if ("chinese".equals(node.getNodeName())) {
				try {
					chinese = Boolean.parseBoolean(node.getChildNodes().item(0)
							.getNodeValue());
				} catch (Exception e) {
				}
			}
			if ("budgetLow".equals(node.getNodeName())) {
				try {
					budgetLow = Integer.parseInt(node.getChildNodes().item(0)
							.getNodeValue());
				} catch (Exception e) {
					budgetLow = 0;// ノード中身は空白の場合
				}
			}
			if ("budgetHigh".equals(node.getNodeName())) {
				try {
					budgetHigh = Integer.parseInt(node.getChildNodes().item(0)
							.getNodeValue());
				} catch (Exception e) {
					budgetHigh = 0;// ノード中身は空白の場合
				}
			}
			if ("withCoupon".equals(node.getNodeName())) {
				try {
					String param = node.getChildNodes().item(0).getNodeValue();
					if ("rdoWithCoupon".equals(param))
						withCoupon = true;
					else
						withCoupon = false;
				} catch (Exception e) {
					withCoupon = false;// ノード中身は空白の場合
				}
			}
		}
	}
}
