package org.maskat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import javax.servlet.http.HttpServletRequest;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;

/**
 * maskatNGXgr_
 * @author pluswing
 *
 */
class MaskatRequestBuilder {
	
	public static MaskatRequest build(HttpServletRequest request) throws IOException, SAXException {
		String xml = loadRequestString(request);
		Node root = getRootNode(xml);
		return createMaskatRequest(root);
	}
	
	private static String loadRequestString(HttpServletRequest request) throws IOException {
		BufferedReader reader = new BufferedReader(request.getReader());
		String line = null;
		StringBuffer xml = new StringBuffer();
		while ((line = reader.readLine()) != null) {
			xml.append(line);
		}
		return xml.toString();
	}
	
	private static Node getRootNode(String xml) throws SAXException, IOException {
		DOMParser parser = new DOMParser();
		parser.parse(new InputSource(new StringReader(xml)));
		return parser.getDocument().getFirstChild();
	}
	
	private static MaskatRequest createMaskatRequest(Node node) {
		
		MaskatRequest request = new MaskatRequest(node.getNodeName(), node.getTextContent());
		NodeList children = node.getChildNodes();
		
		for (int i = 0; i < children.getLength(); i++) {
			request.add(createMaskatRequest(children.item(i)));
		}
		return request;
	}
}
