/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.editors;

import java.util.Iterator;

import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite.FlyoutPreferences;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.maskat.framework.screendef.customize.IComponentPluginConfig;
import org.maskat.framework.screendef.customize.PluginDefFactory;
import org.maskat.ide.gef.requests.ComponentCreateFactory;
import org.maskat.ide.gef.requests.CustomizeComponentCreateFactory;

/**
 * editDomainswtCompositeɑ΂āAflyoutPalettẽT|[g񋟂
 * 
 * @author shengshen
 * 
 */
public class PaletteSupport {
	private PaletteViewerProvider provider;

	private EditDomain ed;

	private FlyoutPaletteComposite splitter;

	PaletteSupport(EditDomain ed) {
		this.ed = ed;
		ed.setPaletteRoot(getPaletteRoot());
	}

	/**
	 * parentewidgetƂāAFlyoutPaletteComposite
	 * 
	 * @param parent
	 * @param page
	 * @return
	 */
	protected Composite getEditorComposite(Composite parent, IWorkbenchPage page) {
		if (splitter != null)
			return splitter;
		splitter = new FlyoutPaletteComposite(parent, SWT.NONE, page,
				getPaletteViewerProvider(), getPalettePreferences());
		return splitter;
	}

	/**
	 * paletteCompositeɎqwidgetƂāAgraphicalControlǉ
	 * 
	 * @param control
	 */
	protected void setGraphicalControl(Control control) {
		splitter.setGraphicalControl(control);
	}

	private PaletteRoot getPaletteRoot() {
		PaletteRoot palette = new PaletteRoot();

		PaletteGroup group = new PaletteGroup("tools"); //$NON-NLS-1$
		ToolEntry entry = new SelectionToolEntry();
		palette.setDefaultEntry(entry);
		group.add(entry);

		group.add(new MarqueeToolEntry());
		palette.add(group);

		ImageDescriptor smallIcon, largeIcon; // pbgŎgpACR

		smallIcon = ImageDescriptor.createFromFile(MaskatEditor.class,
				"/images/componenticon.gif"); //$NON-NLS-1$
		largeIcon = ImageDescriptor.createFromFile(MaskatEditor.class,
				"/images/componenticon.gif"); //$NON-NLS-1$
		PaletteDrawer group_comp = new PaletteDrawer("PR|[lg");

		// toolEntry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED,Boolean.FALSE);

		group_comp.add(new CombinedTemplateCreationEntry("x", "xR|[lg", null,
				ComponentCreateFactory.labelFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("eLXg", "eLXgR|[lg", null,
				ComponentCreateFactory.textFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("{^", "{^R|[lg", null,
				ComponentCreateFactory.btnFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("C[W", "C[WR|[lg", null,
				ComponentCreateFactory.imgFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("R[hu", "R[huR|[lg", null,
				ComponentCreateFactory.codeLibFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("WI", "WIR|[lg", null,
				ComponentCreateFactory.radioFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("`FbN{bNX", "`FbN{bNXR|[lg",
				null, ComponentCreateFactory.checkboxFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("R{{bNX", "R{{bNXR|[lg",
				null, ComponentCreateFactory.comboFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("R{ACe", "R{ACeR|[lg",
				null, ComponentCreateFactory.comboItemFactory, smallIcon, largeIcon));
		group_comp.add(new CombinedTemplateCreationEntry("HTMLeLXg", "HTMLeLXgR|[lg",
				null, ComponentCreateFactory.divHtmlFactory, smallIcon, largeIcon));

		palette.add(group_comp);

		PaletteDrawer group_container = new PaletteDrawer("Rei");
		group_container.add(new CombinedTemplateCreationEntry("t[", "t[R|[lg",
				null, ComponentCreateFactory.frameFactory, smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("EBhE",
				"EBhER|[lg", null, ComponentCreateFactory.splitterFactory,
				smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("^utH_", "^utH_R|[lg",
				null, ComponentCreateFactory.tabFolderFactory, smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("^uACe", "^uACeR|[lg",
				null, ComponentCreateFactory.tabItemFactory, smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("Obh", "ObhR|[lg",
				null, ComponentCreateFactory.gridFactory, smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("Obhwb_[",
				"Obhwb_[R|[lg", null, ComponentCreateFactory.gridHeaderFactory,
				smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("c[", "c[R|[lg", null,
				ComponentCreateFactory.treeFactory, smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("c[m[h", "c[m[h", null,
				ComponentCreateFactory.treeNodeFactory, smallIcon, largeIcon));
		group_container.add(new CombinedTemplateCreationEntry("|bvAbvEBhE",
				"|bvAbvEBhER|[lg", null, ComponentCreateFactory.popupFactory,
				smallIcon, largeIcon));
		palette.add(group_container);

		PaletteDrawer group_custom = new PaletteDrawer("JX^}CYi");
		Iterator it = PluginDefFactory.getPluginComps();
		boolean hasCustomizeComponent = false;
		while (it.hasNext()) {
			IComponentPluginConfig config = (IComponentPluginConfig) it.next();
			group_custom.add(new CombinedTemplateCreationEntry(config.getNodeName(),
					config.getNodeName(), null, new CustomizeComponentCreateFactory(
							config), smallIcon, largeIcon));
			hasCustomizeComponent = true;
		}
		if (hasCustomizeComponent == true) {
			palette.add(group_custom);
		}

		return palette;
	}

	private PaletteViewerProvider createPaletteViewerProvider() {
		return new PaletteViewerProvider(ed);
	}

	private PaletteViewerProvider getPaletteViewerProvider() {
		if (provider == null)
			provider = createPaletteViewerProvider();
		return provider;
	}

	private FlyoutPreferences getPalettePreferences() {
		// pbgݒ̕ۑƕ

		return new FlyoutPreferences() {

			public int getDockLocation() {
				return PositionConstants.EAST;
			}

			public int getPaletteState() {
				return FlyoutPaletteComposite.STATE_PINNED_OPEN;
			}

			public int getPaletteWidth() {
				return 100;
			}

			public void setDockLocation(int location) {

			}

			public void setPaletteState(int state) {

			}

			public void setPaletteWidth(int width) {

			}
		};
	}

	private CustomPalettePage page;

	/**
	 * 
	 */
	final Object getAdapter(Class type) {
		if (type == PalettePage.class) {
			if (splitter == null) {
				page = createPalettePage();
				return page;
			}
			return createPalettePage();
		}
		return null;
	}

	/**
	 * @return a newly-created {@link CustomPalettePage} to be shown in the
	 *         palette view, if null nothing will be shown
	 */
	protected CustomPalettePage createPalettePage() {
		return new CustomPalettePage(getPaletteViewerProvider());
	}

	/**
	 * A custom PalettePage that helps GraphicalEditorWithFlyoutPalette keep the
	 * two PaletteViewers (one displayed in the editor and the other displayed
	 * in the PaletteView) in sync when switching from one to the other (i.e.,
	 * it helps maintain state across the two viewers).
	 * 
	 * @author Pratik Shah
	 */
	private class CustomPalettePage extends PaletteViewerPage {
		/**
		 * Constructor
		 * 
		 * @param provider
		 *            the provider used to create a PaletteViewer
		 */
		public CustomPalettePage(PaletteViewerProvider provider) {
			super(provider);
		}

		/**
		 * @see org.eclipse.ui.part.IPage#createControl(org.eclipse.swt.widgets.Composite)
		 */
		public void createControl(Composite parent) {
			super.createControl(parent);
			if (splitter != null)
				splitter.setExternalViewer(viewer);
		}

		/**
		 * @see org.eclipse.ui.part.IPage#dispose()
		 */
		public void dispose() {
			if (splitter != null)
				splitter.setExternalViewer(null);
			super.dispose();
		}

		/**
		 * @return the PaletteViewer created and displayed by this page
		 */
		public PaletteViewer getPaletteViewer() {
			return viewer;
		}
	}
}
