/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.requests;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.requests.CreationFactory;
import org.maskat.framework.screendef.customize.IComponentPluginConfig;
import org.maskat.framework.screendef.customize.PluginDefFactory;
import org.maskat.framework.screendef.customize.PluginDefUnavailableException;
import org.maskat.ide.MaskatIDEPlugin;

public class CustomizeComponentCreateFactory implements CreationFactory {
	private IComponentPluginConfig config;

	public CustomizeComponentCreateFactory(IComponentPluginConfig config) {
		this.config = config;
	}

	public Object getNewObject() {
		try {
			return PluginDefFactory.newComponentDef(config.getNodeName(), config
					.getNamespace(), config.getPrefix());
		} catch (PluginDefUnavailableException e) {
			MaskatIDEPlugin.getDefault().getLog().log(
					new Status(IStatus.ERROR, MaskatIDEPlugin.PLUGIN_ID, IStatus.ERROR, e
							.getMessage(), e));
			return null;
		}
	}

	public Object getObjectType() {
		return null;
	}

}
