/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.view;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.maskat.framework.eventdef.Param;
import org.maskat.framework.eventdef.Result;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.property.PropertySourceProviderForEditPart;
import org.maskat.ide.view.MaskatEditViewContent;
import org.maskat.ide.view.MaskatPropertySheetPage;

public class MaskatEditView
extends ViewPart
implements ISelectionListener {
    MaskatEditViewContent vc;
    Composite parent;
    private MaskatEditor editTarget;
    private PropertySheetPage page;

    public MaskatEditor getEditTarget() {
        return this.editTarget;
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addSelectionListener((ISelectionListener)this);
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.vc = new MaskatEditViewContent();
        this.vc.setTheView(this);
        this.vc.createPartControl(parent);
    }

    public void showParam(Param param, MaskatEditor ep) {
        boolean changed;
        if (this.editTarget != null && this.editTarget != ep) {
            this.editTarget.editMode = 1;
        }
        this.editTarget = ep;
        if (this.vc != null && (changed = this.vc.showParam(this.parent, param, (CommandStack)ep.getAdapter(CommandStack.class)))) {
            this.setRootEntry();
        }
        this.parent.layout();
        this.getSite().getSelectionProvider().setSelection(this.editTarget.getLastSelectionForEdit());
    }

    public void showResult(Result result, MaskatEditor ep) {
        boolean changed;
        if (this.editTarget != null && this.editTarget != ep) {
            this.editTarget.editMode = 1;
        }
        this.editTarget = ep;
        if (this.vc != null && (changed = this.vc.showResult(this.parent, result, (CommandStack)ep.getAdapter(CommandStack.class)))) {
            this.setRootEntry();
        }
        this.parent.layout();
        this.getSite().getSelectionProvider().setSelection(this.editTarget.getLastSelectionForEdit());
        this.setRootEntry();
    }

    public void setFocus() {
        this.parent.forceFocus();
    }

    public void acceptData(String data) {
        this.vc.acceptData(data);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.vc == null || this.vc.isBlankState()) {
            return;
        }
        if (part instanceof MaskatEditor) {
            StructuredSelection ss;
            MaskatEditor maskatEditor = (MaskatEditor)part;
            if (maskatEditor.gettingFocus) {
                maskatEditor.gettingFocus = false;
                return;
            }
            if (maskatEditor.editMode != 1 && !selection.isEmpty() && selection instanceof StructuredSelection && (ss = (StructuredSelection)selection).getFirstElement() instanceof AbstractGraphicalEditPart) {
                AbstractGraphicalEditPart ssG = (AbstractGraphicalEditPart)ss.getFirstElement();
                Object model = ssG.getModel();
                if (model instanceof IComponentDef) {
                    IComponentDef cm = (IComponentDef)model;
                    this.vc.acceptData(cm.getName());
                }
                if (model instanceof GridHeaderDef) {
                    GridHeaderDef gh = (GridHeaderDef)model;
                    this.vc.acceptData(String.valueOf(gh.idxInParent()));
                }
            }
        }
    }

    private void setRootEntry() {
        if (this.page == null) {
            return;
        }
        UndoablePropertySheetEntry entry = new UndoablePropertySheetEntry(this.vc.getCS());
        entry.setPropertySourceProvider(PropertySourceProviderForEditPart.ins);
        this.page.setRootEntry((IPropertySheetEntry)entry);
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            if (this.vc.getCS() == null) {
                return null;
            }
            this.page = new MaskatPropertySheetPage();
            this.setRootEntry();
            return this.page;
        }
        return super.getAdapter(adapter);
    }

    protected class SelectionProvider
    implements ISelectionProvider {
        private ISelection selection;

        protected SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }
    }
}

