/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.tabbedproperties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.maskat.framework.BasicDef;
import org.maskat.ide.MaskatIDEPlugin;
import org.maskat.ide.editors.MaskatEditor;
import org.maskat.ide.tabbedproperties.ControlWrapper;

public class TableListenerForEditor
extends MouseAdapter {
    private Table targetTable;
    private ControlWrapper[] controls;
    private TableEditor[] tableEditors;
    private String[] propNames;
    private BasicDef basicDef;
    private Class childClass;
    private MaskatEditor editor;
    private TableItem lastSelected;
    private TableItem newHeaderTableItem;

    public TableListenerForEditor(Table targetTable, ControlWrapper[] controls, String[] propNames, BasicDef def, Class childClass, MaskatEditor editor) {
        this.targetTable = targetTable;
        this.controls = controls;
        this.tableEditors = new TableEditor[controls.length];
        int i = 0;
        while (i < controls.length) {
            this.tableEditors[i] = new TableEditor(targetTable);
            this.tableEditors[i].horizontalAlignment = 16384;
            this.tableEditors[i].grabHorizontal = true;
            this.tableEditors[i].minimumWidth = 50;
            ++i;
        }
        this.propNames = propNames;
        this.basicDef = def;
        this.childClass = childClass;
        this.editor = editor;
    }

    public void mouseDown(MouseEvent e) {
        this.resetEditors();
        int index = this.targetTable.getSelectionIndex();
        if (index == -1) {
            return;
        }
        Point pt = new Point(e.x, e.y);
        this.newHeaderTableItem = this.targetTable.getItem(pt);
        TableItem oldItem = this.tableEditors[0].getItem();
        if (this.newHeaderTableItem == oldItem || this.newHeaderTableItem != this.lastSelected) {
            this.lastSelected = this.newHeaderTableItem;
            return;
        }
        this.targetTable.showSelection();
        int i = 0;
        while (i < this.controls.length) {
            Control control = this.controls[i].createControl((Composite)this.targetTable, 0);
            Object targetObj = this.basicDef.getChildByTypeIdx(this.childClass, index);
            while (targetObj == null) {
                try {
                    this.basicDef.addChild(this.childClass.newInstance());
                }
                catch (Exception e1) {
                    MaskatIDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.maskat.ide.gef", 4, e1.getMessage(), (Throwable)e1));
                    return;
                }
                targetObj = this.basicDef.getChildByTypeIdx(this.childClass, index);
            }
            this.controls[i].setValueWatcher(targetObj, this.propNames[i], this.editor);
            this.controls[i].setValue(this.newHeaderTableItem.getText(i));
            this.createControlEditor(control, this.tableEditors[i], i);
            ++i;
        }
        i = 0;
        while (i < this.targetTable.getColumnCount()) {
            Rectangle rect = this.newHeaderTableItem.getBounds(i);
            if (rect.contains(pt)) {
                this.controls[i].getControl().setFocus();
            }
            ++i;
        }
    }

    void createControlEditor(Control control, TableEditor textEditor, int column) {
        control.setFont(this.targetTable.getFont());
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor(control, this.newHeaderTableItem, column);
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TableListenerForEditor.this.resetEditors(true);
                }
                if (e.detail == 2) {
                    TableListenerForEditor.this.outOfFocus();
                }
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    TableListenerForEditor.this.outOfFocus();
                }
            }
        });
        control.setFocus();
    }

    void resetEditors() {
        this.resetEditors(false);
    }

    void resetEditors(boolean tab) {
        TableItem oldItem = this.tableEditors[0].getItem();
        if (oldItem != null) {
            int i = 0;
            while (i < this.controls.length) {
                oldItem.setText(i, this.controls[i].getValue());
                ++i;
            }
        }
        if (!tab) {
            this.disposeEditors();
        }
    }

    void disposeEditors() {
        int i = 0;
        while (i < this.tableEditors.length) {
            this.tableEditors[i].setEditor(null, null, -1);
            ++i;
        }
        i = 0;
        while (i < this.controls.length) {
            if (this.controls[i].getControl() != null) {
                this.controls[i].getControl().dispose();
            }
            ++i;
        }
    }

    void outOfFocus() {
        int i = 0;
        while (i < this.controls.length) {
            Control control = this.controls[i].getControl();
            if (control != null && !control.isDisposed() && control.isFocusControl()) {
                control.notifyListeners(16, null);
            }
            ++i;
        }
        this.resetEditors();
    }
}

