/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.maskat.ide.gef.figure.ComboFigure;
import org.maskat.ide.gef.figure.ComboItemLabel;

public class MaskatFigureHelper {
    private IFigure figure;
    private Rectangle PRIVATE_POINT = new Rectangle();

    MaskatFigureHelper(IFigure figure) {
        this.figure = figure;
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        this.PRIVATE_POINT.setLocation(x, y);
        this.figure.translateFromParent((Translatable)this.PRIVATE_POINT);
        if (!this.figure.getClientArea(Rectangle.SINGLETON).contains(this.PRIVATE_POINT)) {
            return null;
        }
        x = this.PRIVATE_POINT.x;
        y = this.PRIVATE_POINT.y;
        IFigure result = null;
        int i = this.figure.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.figure.getChildren().get(--i);
            if (!fig.isVisible()) continue;
            if ((fig = fig.findFigureAt(x, y, search)) instanceof ComboItemLabel) {
                return fig;
            }
            if (result != null) continue;
            result = fig;
        }
        return result;
    }

    protected void paintChildren(Graphics graphics) {
        Rectangle clip = Rectangle.SINGLETON;
        int i = 0;
        while (i < this.figure.getChildren().size()) {
            IFigure child = (IFigure)this.figure.getChildren().get(i);
            if (child instanceof ComboFigure && child.isVisible() && child.intersects(graphics.getClip(clip)) && ((ComboFigure)child).isChildrenShown()) {
                graphics.clipRect(child.getBounds());
                child.paint(graphics);
                graphics.restoreState();
            }
            ++i;
        }
    }
}

