/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.maskat.framework.screendef.ComponentDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.PopupDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.ide.gef.editparts.SplitEditPart;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.MyXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.SplitterFigure;
import org.maskat.ide.gef.models.SplitModel;

public class SplitterEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    private int currentSelectedSplitIdx = 0;
    private int splitThickness = 8;
    private SplitModel split;

    public int getCurrentSelectedSplitIdx() {
        return this.currentSelectedSplitIdx;
    }

    public void activate() {
        super.activate();
        ComponentDef model = (ComponentDef)this.getModel();
        model.addPropertyChangeListener(this);
    }

    public void deactivate() {
        ComponentDef model = (ComponentDef)this.getModel();
        model.removePropertyChangeListener(this);
        super.deactivate();
    }

    protected IFigure createFigure() {
        SplitterFigure splitterFig = new SplitterFigure();
        XYLayout layout = new XYLayout();
        splitterFig.setLayoutManager((LayoutManager)layout);
        splitterFig.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
        return splitterFig;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MaskatComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MyXYLayoutEditPolicy());
    }

    protected List getModelChildren() {
        SplitterDef splitterDef = (SplitterDef)this.getModel();
        List children = splitterDef.getComponentChildren();
        ArrayList<Object> result = new ArrayList<Object>();
        for (DivSplitDef divSplit : children) {
            result.add(divSplit);
        }
        this.split = new SplitModel(splitterDef, this.splitThickness);
        result.add(this.split);
        this.calcSplitSize();
        this.calcDivSplitSize();
        return result;
    }

    protected void refreshVisuals() {
        IComponentDef comp = (IComponentDef)this.getModel();
        Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), comp.getHeight());
        if (this.getParent().getModel() instanceof PopupDef) {
            constraint.y += 20;
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    public void doSwitch() {
        this.currentSelectedSplitIdx = 1 - this.currentSelectedSplitIdx;
        this.calcSplitSize();
        int i = 0;
        while (i < this.getChildren().size()) {
            AbstractGraphicalEditPart editPart = (AbstractGraphicalEditPart)this.getChildren().get(i);
            if (editPart instanceof SplitEditPart) {
                this.setLayoutConstraint((EditPart)editPart, editPart.getFigure(), new Rectangle(this.split.getX(), this.split.getY(), this.split.getWidth(), this.split.getHeight()));
            }
            ++i;
        }
    }

    private void calcSplitSize() {
        SplitterDef splitterDef = (SplitterDef)this.getModel();
        boolean isHorizontal = splitterDef.isHorizontal();
        if (isHorizontal) {
            this.split.setWidth(this.splitThickness);
            this.split.setHeight(splitterDef.getHeight() - 1);
            this.split.setY(0);
            if (this.currentSelectedSplitIdx == 0) {
                this.split.setX(splitterDef.getWidth() - this.splitThickness - 1);
            } else {
                this.split.setX(0);
            }
        } else {
            this.split.setWidth(splitterDef.getWidth() - 1);
            this.split.setHeight(this.splitThickness);
            this.split.setX(0);
            if (this.currentSelectedSplitIdx == 0) {
                this.split.setY(splitterDef.getHeight() - this.splitThickness - 1);
            } else {
                this.split.setY(0);
            }
        }
    }

    private void calcDivSplitSize() {
        SplitterDef splitterDef = (SplitterDef)this.getModel();
        boolean isHorizontal = splitterDef.isHorizontal();
        DivSplitDef div0 = (DivSplitDef)splitterDef.getChildByTypeIdx(DivSplitDef.class, 0);
        DivSplitDef div1 = (DivSplitDef)splitterDef.getChildByTypeIdx(DivSplitDef.class, 1);
        if (isHorizontal) {
            if (div0 != null) {
                div0.setLeft(0);
                div0.setTop(0);
                div0.setWidth(splitterDef.getWidth() - this.splitThickness - 1);
                div0.setHeight(splitterDef.getHeight() - 1);
            }
            if (div1 != null) {
                div1.setLeft(this.splitThickness);
                div1.setTop(0);
                div1.setWidth(splitterDef.getWidth() - this.splitThickness - 1);
                div1.setHeight(splitterDef.getHeight() - 1);
            }
        } else {
            if (div0 != null) {
                div0.setLeft(0);
                div0.setTop(0);
                div0.setWidth(splitterDef.getWidth() - 1);
                div0.setHeight(splitterDef.getHeight() - this.splitThickness - 1);
            }
            if (div1 != null) {
                div1.setLeft(0);
                div1.setTop(this.splitThickness);
                div1.setWidth(splitterDef.getWidth() - 1);
                div1.setHeight(splitterDef.getHeight() - this.splitThickness - 1);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.calcSplitSize();
        this.calcDivSplitSize();
        this.refreshVisuals();
    }
}

