/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.gef.editparts;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.maskat.framework.CUtil;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.ComboItemDef;
import org.maskat.framework.screendef.PopupDef;
import org.maskat.ide.gef.editparts.ComponentEditPart;
import org.maskat.ide.gef.figure.ComboFigure;

public class ComboboxEditPart
extends ComponentEditPart {
    public static final int MIN_HEIGHT_ITEM = 15;

    public void activate() {
        this.addEditPartListener((EditPartListener)new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart part) {
                if (part.getSelected() == 2) {
                    ComboboxEditPart.this.setShowChildren(true);
                } else {
                    ComboboxEditPart.this.setShowChildren(false);
                }
                ComboboxEditPart.this.refresh();
                super.selectedStateChanged(part);
            }
        });
        super.activate();
    }

    public boolean isShowChildren() {
        return ((ComboFigure)this.getFigure()).isChildrenShown();
    }

    public void setShowChildren(boolean showChildren) {
        ((ComboFigure)this.getFigure()).setChildrenShown(showChildren);
        this.refresh();
        if (!showChildren) {
            ((ComboFigure)this.getFigure()).setIcon(COMBOBOXDROPDOWN);
        } else {
            ((ComboFigure)this.getFigure()).setIcon(null);
        }
    }

    protected IFigure createFigure() {
        ComboFigure label = new ComboFigure("\u3000\u3000\u3000\u3000", COMBOBOXDROPDOWN);
        label.setFont(DEFAULT_FONT);
        label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(0)));
        label.setTextPlacement(8);
        label.setLabelAlignment(8);
        label.setOpaque(false);
        XYLayout layout = new XYLayout();
        label.setLayoutManager((LayoutManager)layout);
        return label;
    }

    protected List getModelChildren() {
        ComboDef cd = (ComboDef)this.getModel();
        List result = cd.getUnmodifiableChildren();
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    protected void refreshVisuals() {
        Iterator it;
        ComboDef combo = (ComboDef)this.getModel();
        int displayHeight = 20;
        if (this.isShowChildren()) {
            int heightItem = CUtil.safeToInt(combo.getHeightItem());
            heightItem = Math.max(heightItem, 15);
            it = combo.getTypedChildren(ComboItemDef.class);
            int childCount = 0;
            while (it != null && it.hasNext()) {
                ++childCount;
                it.next();
            }
            displayHeight += heightItem * childCount;
            this.getFigure().setOpaque(true);
        } else {
            this.getFigure().setOpaque(false);
        }
        Rectangle constraint = new Rectangle(combo.getLeft(), combo.getTop(), combo.getWidth(), displayHeight);
        if (this.getParent().getModel() instanceof PopupDef) {
            constraint.y += 20;
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        it = this.getChildren().iterator();
        while (it.hasNext()) {
            ((EditPart)it.next()).refresh();
        }
    }
}

