/*
 * Decompiled with CFR 0.152.
 */
package org.maskat.ide.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.maskat.framework.eventdef.xml.TelegramSchemaGenerator;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.ide.MaskatIDEPlugin;
import org.maskat.ide.MaskatProjectPropertyPage;
import org.maskat.ide.action.DelComponentAction;
import org.maskat.ide.editors.EditorData;
import org.maskat.ide.editors.PaletteSupport;
import org.maskat.ide.gef.editparts.MaskatEditPartFactory;
import org.maskat.ide.property.PropertySourceProviderForEditPart;
import org.maskat.ide.tabbedproperties.MaskatTabbedPropertySheetPage;

public class MaskatEditor
extends GraphicalEditor
implements ITabbedPropertySheetPageContributor {
    public static final String ID = "org.maskat.ide.gef.editor1";
    public boolean gettingFocus = false;
    protected EditorData data;
    public static final int SCREEN_EDIT_MODE = 1;
    public static final int SOURCE_EDIT_MODE = 2;
    public static final int TARGET_EDIT_MODE = 4;
    public int editMode = 1;
    private PaletteSupport paletteSupport;
    Composite splitter;
    private boolean isThisEditorSaving = false;
    private IResourceChangeListener listener;
    private boolean dirty = false;
    private IFile layoutXmlFile;
    private ISelection lastSelectionForEdit;

    public void setFocus() {
        super.setFocus();
        this.gettingFocus = true;
    }

    public MaskatEditor() {
        DefaultEditDomain ed = new DefaultEditDomain((IEditorPart)this);
        this.paletteSupport = new PaletteSupport((EditDomain)ed);
        this.setEditDomain(ed);
    }

    public void createPartControl(Composite parent) {
        this.splitter = this.paletteSupport.getEditorComposite(parent, this.getSite().getPage());
        super.createPartControl(this.splitter);
        this.paletteSupport.setGraphicalControl(this.getGraphicalViewer().getControl());
    }

    protected Composite getControl() {
        return this.splitter;
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.genContextMenu();
        viewer.setContents((Object)this.getCurrentLayoutDef());
        this.createSourceListener();
    }

    protected void genContextMenu() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        MenuManager mm = viewer.getContextMenu();
        if (mm == null) {
            mm = new MenuManager();
            viewer.setContextMenu(mm);
        }
        mm.removeAll();
        MenuManager subMenu = new MenuManager("\u30ec\u30a4\u30a2\u30a6\u30c8");
        Iterator it = this.data.getLayouts();
        int currentIdx = 0;
        while (it.hasNext()) {
            LayoutDef layoutDef = (LayoutDef)it.next();
            final int theIdx = currentIdx;
            Action action = new Action(layoutDef.getName() == null ? "anonymous" + theIdx : layoutDef.getName(), 8){

                public void run() {
                    MaskatEditor.this.data.switchLayout(theIdx);
                    MaskatEditor.this.getGraphicalViewer().setContents((Object)MaskatEditor.this.getCurrentLayoutDef());
                }
            };
            action.setId(String.valueOf(theIdx));
            if (currentIdx == 0) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
            subMenu.add((IAction)action);
            ++currentIdx;
        }
        mm.add((IContributionItem)subMenu);
        this.genContextDelMenu();
    }

    private void genContextDelMenu() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        MenuManager mm = viewer.getContextMenu();
        DelComponentAction delAction = new DelComponentAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)delAction);
        this.getSelectionActions().add(delAction.getId());
        mm.add((IAction)delAction);
    }

    protected LayoutDef getCurrentLayoutDef() {
        return this.data.getCurrentLayoutDef();
    }

    private void createSourceListener() {
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (MaskatEditor.this.isThisEditorSaving) {
                    return;
                }
                IEditorInput editorInput = MaskatEditor.this.getEditorInput();
                IFile iFile = (IFile)editorInput.getAdapter(IFile.class);
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(iFile.getFullPath());
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                if (visitor.isHit()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                MaskatEditor.this.initLoad(MaskatEditor.this.getEditorInput());
                                (this).MaskatEditor.this.data.connectLayoutEvent();
                                MaskatEditor.this.genContextMenu();
                                MaskatEditor.this.getGraphicalViewer().setContents((Object)MaskatEditor.this.getCurrentLayoutDef());
                                MaskatEditor.this.getCommandStack().flush();
                                MaskatEditor.this.dirty = false;
                            }
                            catch (PartInitException e) {
                                MaskatIDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.maskat.ide.gef", 4, e.getMessage(), (Throwable)e));
                            }
                        }
                    });
                }
            }
        };
        MaskatIDEPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            try {
                this.isThisEditorSaving = true;
                StringWriter strWriter = new StringWriter(1024);
                this.data.writeLayout(strWriter);
                byte[] bytes = strWriter.toString().getBytes("UTF-8");
                this.layoutXmlFile.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, monitor);
                String[] results = this.data.writeEvent();
                IProject project = this.layoutXmlFile.getProject();
                String confirmOption = project.getPersistentProperty(MaskatProjectPropertyPage.SCHEMA_GENERATE_PROPERTY);
                if (confirmOption == null) {
                    confirmOption = "2";
                }
                boolean confirm = true;
                if ("1".equals(confirmOption)) {
                    confirm = false;
                }
                if ("2".equals(confirmOption)) {
                    confirm = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"\u30b9\u30ad\u30fc\u30de\u751f\u6210", (String)"\u30b9\u30ad\u30fc\u30de\u81ea\u52d5\u751f\u6210\u3057\u307e\u3059\u3001\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f");
                }
                if (confirm) {
                    int i = 0;
                    while (i < results.length) {
                        String result = results[i];
                        IPath path = this.layoutXmlFile.getProjectRelativePath();
                        TelegramSchemaGenerator.generate(new ByteArrayInputStream(result.getBytes("UTF-8")), project, path.removeLastSegments(1));
                        ++i;
                    }
                }
                this.getCommandStack().markSaveLocation();
                this.dirty = false;
                this.firePropertyChange(257);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"\u4fdd\u5b58", (String)"\u4fdd\u5b58\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)e.getStatus());
            }
            catch (Exception e) {
                Status status = new Status(4, "org.maskat.ide.gef", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"\u4fdd\u5b58", (String)"\u4fdd\u5b58\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (IStatus)status);
            }
        }
        finally {
            this.isThisEditorSaving = false;
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty() || this.dirty;
    }

    public void makeDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.firePropertyChange(257);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new MaskatEditPartFactory());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.initLoad(input);
        super.init(site, input);
    }

    private void initLoad(IEditorInput input) throws PartInitException {
        this.layoutXmlFile = (IFile)input.getAdapter(IFile.class);
        if (this.layoutXmlFile != null) {
            this.setPartName(this.layoutXmlFile.getName());
        }
        this.data = new EditorData(this.layoutXmlFile);
        try {
            this.data.loadLayout();
            this.data.loadEvent();
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
        catch (Exception e) {
            Status status = new Status(4, "org.maskat.ide.gef", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            throw new PartInitException((IStatus)status);
        }
        this.data.connectLayoutEvent();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (selection instanceof TextSelection) {
            TextSelection txtSel = (TextSelection)selection;
            ArrayList targets = new ArrayList();
            if (txtSel.getText() == null) {
                return;
            }
            this.searchForNamedComponent(this.getGraphicalViewer().getRootEditPart().getContents(), txtSel.getText(), targets);
            this.getGraphicalViewer().deselectAll();
            int i = 0;
            while (i < targets.size()) {
                EditPart target = (EditPart)targets.get(i);
                this.getGraphicalViewer().appendSelection(target);
                if (i == 0) {
                    this.getGraphicalViewer().reveal(target);
                }
                ++i;
            }
        }
    }

    public void searchForNamedComponent(EditPart root, String name, List list) {
        if (root == null || root.getChildren() == null) {
            return;
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            EditPart editPart = (EditPart)root.getChildren().get(i);
            if (editPart.getModel() instanceof IComponentDef && name.equals(((IComponentDef)editPart.getModel()).getName())) {
                list.add(editPart);
            }
            this.searchForNamedComponent(editPart, name, list);
            ++i;
        }
    }

    public void dispose() {
        MaskatIDEPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetEntry.class) {
            UndoablePropertySheetEntry entry = new UndoablePropertySheetEntry(this.getCommandStack());
            entry.setPropertySourceProvider(PropertySourceProviderForEditPart.ins);
            return entry;
        }
        if (type == IPropertySheetPage.class && type == IPropertySheetPage.class) {
            return new MaskatTabbedPropertySheetPage(this);
        }
        Object result = this.paletteSupport.getAdapter(type);
        if (result != null) {
            return result;
        }
        return super.getAdapter(type);
    }

    public ISelection getLastSelectionForEdit() {
        return this.lastSelectionForEdit;
    }

    public void setLastSelectionForEdit(ISelection lastSelectionForEdit) {
        this.lastSelectionForEdit = lastSelectionForEdit;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private IPath targetResourcePath;
        private boolean hit = false;

        public boolean isHit() {
            return this.hit;
        }

        public ResourceDeltaVisitor(IPath targetResourcePath) {
            this.targetResourcePath = targetResourcePath;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!delta.getFullPath().equals((Object)this.targetResourcePath)) break;
                    this.hit = true;
                    break;
                }
                case 4: {
                    if (!delta.getFullPath().equals((Object)this.targetResourcePath)) break;
                    this.hit = true;
                }
            }
            return true;
        }
    }
}

